/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.projectenv.agent;

import io.jenkins.plugins.projectenv.agent.AgentInfo;
import io.jenkins.plugins.projectenv.agent.ImmutableAgentInfo;
import io.jenkins.plugins.projectenv.agent.OperatingSystem;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.lang.SystemUtils;

public class AgentInfoCallable
extends MasterToSlaveCallable<AgentInfo, Exception> {
    public AgentInfo call() throws Exception {
        OperatingSystem operatingSystem = this.getOperatingSystem();
        return ImmutableAgentInfo.builder().lineSeparator(System.lineSeparator()).operatingSystem(operatingSystem).build();
    }

    private OperatingSystem getOperatingSystem() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return OperatingSystem.WINDOWS;
        }
        if (SystemUtils.IS_OS_MAC) {
            return OperatingSystem.MACOS;
        }
        if (SystemUtils.IS_OS_LINUX) {
            return OperatingSystem.LINUX;
        }
        throw new IllegalStateException("unsupported OS " + SystemUtils.OS_NAME);
    }
}

