package io.jenkins.plugins.projectenv.toolinfo;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ToolInfo}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableToolInfo.builder()}.
 */
@Generated(from = "ToolInfo", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableToolInfo implements ToolInfo {
  private final @Nullable String primaryExecutable;
  private final Map<String, String> environmentVariables;
  private final List<String> pathElements;
  private final Map<String, String> unhandledProjectResources;

  private ImmutableToolInfo(
      @Nullable String primaryExecutable,
      Map<String, String> environmentVariables,
      List<String> pathElements,
      Map<String, String> unhandledProjectResources) {
    this.primaryExecutable = primaryExecutable;
    this.environmentVariables = environmentVariables;
    this.pathElements = pathElements;
    this.unhandledProjectResources = unhandledProjectResources;
  }

  /**
   * @return The value of the {@code primaryExecutable} attribute
   */
  @Override
  public Optional<String> getPrimaryExecutable() {
    return Optional.ofNullable(primaryExecutable);
  }

  /**
   * @return The value of the {@code environmentVariables} attribute
   */
  @Override
  public Map<String, String> getEnvironmentVariables() {
    return environmentVariables;
  }

  /**
   * @return The value of the {@code pathElements} attribute
   */
  @Override
  public List<String> getPathElements() {
    return pathElements;
  }

  /**
   * @return The value of the {@code unhandledProjectResources} attribute
   */
  @Override
  public Map<String, String> getUnhandledProjectResources() {
    return unhandledProjectResources;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ToolInfo#getPrimaryExecutable() primaryExecutable} attribute.
   * @param value The value for primaryExecutable
   * @return A modified copy of {@code this} object
   */
  public final ImmutableToolInfo withPrimaryExecutable(String value) {
    String newValue = Objects.requireNonNull(value, "primaryExecutable");
    if (Objects.equals(this.primaryExecutable, newValue)) return this;
    return new ImmutableToolInfo(newValue, this.environmentVariables, this.pathElements, this.unhandledProjectResources);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ToolInfo#getPrimaryExecutable() primaryExecutable} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for primaryExecutable
   * @return A modified copy of {@code this} object
   */
  public final ImmutableToolInfo withPrimaryExecutable(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.primaryExecutable, value)) return this;
    return new ImmutableToolInfo(value, this.environmentVariables, this.pathElements, this.unhandledProjectResources);
  }

  /**
   * Copy the current immutable object by replacing the {@link ToolInfo#getEnvironmentVariables() environmentVariables} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the environmentVariables map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableToolInfo withEnvironmentVariables(Map<String, ? extends String> entries) {
    if (this.environmentVariables == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableToolInfo(this.primaryExecutable, newValue, this.pathElements, this.unhandledProjectResources);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ToolInfo#getPathElements() pathElements}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableToolInfo withPathElements(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableToolInfo(this.primaryExecutable, this.environmentVariables, newValue, this.unhandledProjectResources);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ToolInfo#getPathElements() pathElements}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of pathElements elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableToolInfo withPathElements(Iterable<String> elements) {
    if (this.pathElements == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableToolInfo(this.primaryExecutable, this.environmentVariables, newValue, this.unhandledProjectResources);
  }

  /**
   * Copy the current immutable object by replacing the {@link ToolInfo#getUnhandledProjectResources() unhandledProjectResources} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the unhandledProjectResources map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableToolInfo withUnhandledProjectResources(Map<String, ? extends String> entries) {
    if (this.unhandledProjectResources == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableToolInfo(this.primaryExecutable, this.environmentVariables, this.pathElements, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableToolInfo} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableToolInfo
        && equalTo(0, (ImmutableToolInfo) another);
  }

  private boolean equalTo(int synthetic, ImmutableToolInfo another) {
    return Objects.equals(primaryExecutable, another.primaryExecutable)
        && environmentVariables.equals(another.environmentVariables)
        && pathElements.equals(another.pathElements)
        && unhandledProjectResources.equals(another.unhandledProjectResources);
  }

  /**
   * Computes a hash code from attributes: {@code primaryExecutable}, {@code environmentVariables}, {@code pathElements}, {@code unhandledProjectResources}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(primaryExecutable);
    h += (h << 5) + environmentVariables.hashCode();
    h += (h << 5) + pathElements.hashCode();
    h += (h << 5) + unhandledProjectResources.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ToolInfo} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ToolInfo{");
    if (primaryExecutable != null) {
      builder.append("primaryExecutable=").append(primaryExecutable);
    }
    if (builder.length() > 9) builder.append(", ");
    builder.append("environmentVariables=").append(environmentVariables);
    builder.append(", ");
    builder.append("pathElements=").append(pathElements);
    builder.append(", ");
    builder.append("unhandledProjectResources=").append(unhandledProjectResources);
    return builder.append("}").toString();
  }

  /**
   * Creates an immutable copy of a {@link ToolInfo} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ToolInfo instance
   */
  public static ImmutableToolInfo copyOf(ToolInfo instance) {
    if (instance instanceof ImmutableToolInfo) {
      return (ImmutableToolInfo) instance;
    }
    return ImmutableToolInfo.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableToolInfo ImmutableToolInfo}.
   * <pre>
   * ImmutableToolInfo.builder()
   *    .primaryExecutable(String) // optional {@link ToolInfo#getPrimaryExecutable() primaryExecutable}
   *    .putEnvironmentVariables|putAllEnvironmentVariables(String =&gt; String) // {@link ToolInfo#getEnvironmentVariables() environmentVariables} mappings
   *    .addPathElements|addAllPathElements(String) // {@link ToolInfo#getPathElements() pathElements} elements
   *    .putUnhandledProjectResources|putAllUnhandledProjectResources(String =&gt; String) // {@link ToolInfo#getUnhandledProjectResources() unhandledProjectResources} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableToolInfo builder
   */
  public static ImmutableToolInfo.Builder builder() {
    return new ImmutableToolInfo.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableToolInfo ImmutableToolInfo}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ToolInfo", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String primaryExecutable;
    private Map<String, String> environmentVariables = new LinkedHashMap<String, String>();
    private List<String> pathElements = new ArrayList<String>();
    private Map<String, String> unhandledProjectResources = new LinkedHashMap<String, String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ToolInfo} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ToolInfo instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<String> primaryExecutableOptional = instance.getPrimaryExecutable();
      if (primaryExecutableOptional.isPresent()) {
        primaryExecutable(primaryExecutableOptional);
      }
      putAllEnvironmentVariables(instance.getEnvironmentVariables());
      addAllPathElements(instance.getPathElements());
      putAllUnhandledProjectResources(instance.getUnhandledProjectResources());
      return this;
    }

    /**
     * Initializes the optional value {@link ToolInfo#getPrimaryExecutable() primaryExecutable} to primaryExecutable.
     * @param primaryExecutable The value for primaryExecutable
     * @return {@code this} builder for chained invocation
     */
    public final Builder primaryExecutable(String primaryExecutable) {
      this.primaryExecutable = Objects.requireNonNull(primaryExecutable, "primaryExecutable");
      return this;
    }

    /**
     * Initializes the optional value {@link ToolInfo#getPrimaryExecutable() primaryExecutable} to primaryExecutable.
     * @param primaryExecutable The value for primaryExecutable
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder primaryExecutable(Optional<String> primaryExecutable) {
      this.primaryExecutable = primaryExecutable.orElse(null);
      return this;
    }

    /**
     * Put one entry to the {@link ToolInfo#getEnvironmentVariables() environmentVariables} map.
     * @param key The key in the environmentVariables map
     * @param value The associated value in the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putEnvironmentVariables(String key, String value) {
      this.environmentVariables.put(
          Objects.requireNonNull(key, "environmentVariables key"),
          Objects.requireNonNull(value, value == null ? "environmentVariables value for key: " + key : null));
      return this;
    }

    /**
     * Put one entry to the {@link ToolInfo#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putEnvironmentVariables(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.environmentVariables.put(
          Objects.requireNonNull(k, "environmentVariables key"),
          Objects.requireNonNull(v, v == null ? "environmentVariables value for key: " + k : null));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ToolInfo#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted
     * @param entries The entries that will be added to the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentVariables(Map<String, ? extends String> entries) {
      this.environmentVariables.clear();
      return putAllEnvironmentVariables(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ToolInfo#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted
     * @param entries The entries that will be added to the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllEnvironmentVariables(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.environmentVariables.put(
            Objects.requireNonNull(k, "environmentVariables key"),
            Objects.requireNonNull(v, v == null ? "environmentVariables value for key: " + k : null));
      }
      return this;
    }

    /**
     * Adds one element to {@link ToolInfo#getPathElements() pathElements} list.
     * @param element A pathElements element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addPathElements(String element) {
      this.pathElements.add(Objects.requireNonNull(element, "pathElements element"));
      return this;
    }

    /**
     * Adds elements to {@link ToolInfo#getPathElements() pathElements} list.
     * @param elements An array of pathElements elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addPathElements(String... elements) {
      for (String element : elements) {
        this.pathElements.add(Objects.requireNonNull(element, "pathElements element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ToolInfo#getPathElements() pathElements} list.
     * @param elements An iterable of pathElements elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder pathElements(Iterable<String> elements) {
      this.pathElements.clear();
      return addAllPathElements(elements);
    }

    /**
     * Adds elements to {@link ToolInfo#getPathElements() pathElements} list.
     * @param elements An iterable of pathElements elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllPathElements(Iterable<String> elements) {
      for (String element : elements) {
        this.pathElements.add(Objects.requireNonNull(element, "pathElements element"));
      }
      return this;
    }

    /**
     * Put one entry to the {@link ToolInfo#getUnhandledProjectResources() unhandledProjectResources} map.
     * @param key The key in the unhandledProjectResources map
     * @param value The associated value in the unhandledProjectResources map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putUnhandledProjectResources(String key, String value) {
      this.unhandledProjectResources.put(
          Objects.requireNonNull(key, "unhandledProjectResources key"),
          Objects.requireNonNull(value, value == null ? "unhandledProjectResources value for key: " + key : null));
      return this;
    }

    /**
     * Put one entry to the {@link ToolInfo#getUnhandledProjectResources() unhandledProjectResources} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putUnhandledProjectResources(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.unhandledProjectResources.put(
          Objects.requireNonNull(k, "unhandledProjectResources key"),
          Objects.requireNonNull(v, v == null ? "unhandledProjectResources value for key: " + k : null));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ToolInfo#getUnhandledProjectResources() unhandledProjectResources} map. Nulls are not permitted
     * @param entries The entries that will be added to the unhandledProjectResources map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder unhandledProjectResources(Map<String, ? extends String> entries) {
      this.unhandledProjectResources.clear();
      return putAllUnhandledProjectResources(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ToolInfo#getUnhandledProjectResources() unhandledProjectResources} map. Nulls are not permitted
     * @param entries The entries that will be added to the unhandledProjectResources map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllUnhandledProjectResources(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.unhandledProjectResources.put(
            Objects.requireNonNull(k, "unhandledProjectResources key"),
            Objects.requireNonNull(v, v == null ? "unhandledProjectResources value for key: " + k : null));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableToolInfo ImmutableToolInfo}.
     * @return An immutable instance of ToolInfo
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableToolInfo build() {
      return new ImmutableToolInfo(
          primaryExecutable,
          createUnmodifiableMap(false, false, environmentVariables),
          createUnmodifiableList(true, pathElements),
          createUnmodifiableMap(false, false, unhandledProjectResources));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
