package io.jenkins.plugins.projectenv.toolinfo;

import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.processing.Generated;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code ToolInfo}.
 * @see ImmutableToolInfo
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "io.jenkins.plugins.projectenv.toolinfo", generator = "Gsons")
public final class GsonAdaptersToolInfo implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (ToolInfoTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new ToolInfoTypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersToolInfo(ToolInfo)";
  }

  @org.immutables.value.Generated(from = "ToolInfo", generator = "Gsons")
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  private static class ToolInfoTypeAdapter extends TypeAdapter<ToolInfo> {

    ToolInfoTypeAdapter(Gson gson) {
    } 

    static boolean adapts(TypeToken<?> type) {
      return ToolInfo.class == type.getRawType()
          || ImmutableToolInfo.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, ToolInfo value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeToolInfo(out, value);
      }
    }

    @Override
    public ToolInfo read(JsonReader in) throws IOException {
      return readToolInfo(in);
    }

    private void writeToolInfo(JsonWriter out, ToolInfo instance)
        throws IOException {
      out.beginObject();
      Optional<String> primaryExecutableOptional = instance.getPrimaryExecutable();
      if (primaryExecutableOptional.isPresent()) {
        out.name("primaryExecutable");
        String primaryExecutableValue = primaryExecutableOptional.get();
        out.value(primaryExecutableValue);
      } else if (out.getSerializeNulls()) {
        out.name("primaryExecutable");
        out.nullValue();
      }
      Map<String, String> environmentVariablesMapping = instance.getEnvironmentVariables();
      out.name("environmentVariables");
      out.beginObject();
      for (Map.Entry<String, String> e : environmentVariablesMapping.entrySet()) {
        String key = e.getKey();
        out.name(key);
        String value = e.getValue();
        out.value(value);
      }
      out.endObject();
      List<String> pathElementsElements = instance.getPathElements();
      out.name("pathElements");
      out.beginArray();
      for (String e : pathElementsElements) {
        out.value(e);
      }
      out.endArray();
      Map<String, String> unhandledProjectResourcesMapping = instance.getUnhandledProjectResources();
      out.name("unhandledProjectResources");
      out.beginObject();
      for (Map.Entry<String, String> e : unhandledProjectResourcesMapping.entrySet()) {
        String key = e.getKey();
        out.name(key);
        String value = e.getValue();
        out.value(value);
      }
      out.endObject();
      out.endObject();
    }

    private  ToolInfo readToolInfo(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableToolInfo.Builder builder = ImmutableToolInfo.builder();
      in.beginObject();
      while (in.hasNext()) {
        eachAttribute(in, builder);
      }
      in.endObject();
      return builder.build();
    }

    private void eachAttribute(JsonReader in, ImmutableToolInfo.Builder builder)
        throws IOException {
      String attributeName = in.nextName();
      switch (attributeName.charAt(0)) {
      case 'p':
        if ("primaryExecutable".equals(attributeName)) {
          readInPrimaryExecutable(in, builder);
          return;
        }
        if ("pathElements".equals(attributeName)) {
          readInPathElements(in, builder);
          return;
        }
        break;
      case 'e':
        if ("environmentVariables".equals(attributeName)) {
          readInEnvironmentVariables(in, builder);
          return;
        }
        break;
      case 'u':
        if ("unhandledProjectResources".equals(attributeName)) {
          readInUnhandledProjectResources(in, builder);
          return;
        }
        break;
      default:
      }
      in.skipValue();
    }

    private void readInPrimaryExecutable(JsonReader in, ImmutableToolInfo.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.primaryExecutable(in.nextString());
      }
    }

    private void readInEnvironmentVariables(JsonReader in, ImmutableToolInfo.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        in.beginObject();
        while(in.hasNext()) {
          String rawKey = in.nextName();
          String key = rawKey;
          String value = in.nextString();
          builder.putEnvironmentVariables(key, value);
        }
        in.endObject();
      }
    }

    private void readInPathElements(JsonReader in, ImmutableToolInfo.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.BEGIN_ARRAY) {
        in.beginArray();
        while(in.hasNext()) {
          builder.addPathElements(in.nextString());
        }
        in.endArray();
      } else if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.addPathElements(in.nextString());
      }
    }

    private void readInUnhandledProjectResources(JsonReader in, ImmutableToolInfo.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        in.beginObject();
        while(in.hasNext()) {
          String rawKey = in.nextName();
          String key = rawKey;
          String value = in.nextString();
          builder.putUnhandledProjectResources(key, value);
        }
        in.endObject();
      }
    }
  }
}
