package io.jenkins.plugins.projectenv.proc;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ProcResult}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableProcResult.builder()}.
 */
@Generated(from = "ProcResult", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableProcResult implements ProcResult {
  private final int exitCode;
  private final String stdOutput;

  private ImmutableProcResult(int exitCode, String stdOutput) {
    this.exitCode = exitCode;
    this.stdOutput = stdOutput;
  }

  /**
   * @return The value of the {@code exitCode} attribute
   */
  @Override
  public int getExitCode() {
    return exitCode;
  }

  /**
   * @return The value of the {@code stdOutput} attribute
   */
  @Override
  public String getStdOutput() {
    return stdOutput;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcResult#getExitCode() exitCode} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for exitCode
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcResult withExitCode(int value) {
    if (this.exitCode == value) return this;
    return new ImmutableProcResult(value, this.stdOutput);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcResult#getStdOutput() stdOutput} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for stdOutput
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcResult withStdOutput(String value) {
    String newValue = Objects.requireNonNull(value, "stdOutput");
    if (this.stdOutput.equals(newValue)) return this;
    return new ImmutableProcResult(this.exitCode, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableProcResult} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableProcResult
        && equalTo(0, (ImmutableProcResult) another);
  }

  private boolean equalTo(int synthetic, ImmutableProcResult another) {
    return exitCode == another.exitCode
        && stdOutput.equals(another.stdOutput);
  }

  /**
   * Computes a hash code from attributes: {@code exitCode}, {@code stdOutput}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + exitCode;
    h += (h << 5) + stdOutput.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ProcResult} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ProcResult{"
        + "exitCode=" + exitCode
        + ", stdOutput=" + stdOutput
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ProcResult} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ProcResult instance
   */
  public static ImmutableProcResult copyOf(ProcResult instance) {
    if (instance instanceof ImmutableProcResult) {
      return (ImmutableProcResult) instance;
    }
    return ImmutableProcResult.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableProcResult ImmutableProcResult}.
   * <pre>
   * ImmutableProcResult.builder()
   *    .exitCode(int) // required {@link ProcResult#getExitCode() exitCode}
   *    .stdOutput(String) // required {@link ProcResult#getStdOutput() stdOutput}
   *    .build();
   * </pre>
   * @return A new ImmutableProcResult builder
   */
  public static ImmutableProcResult.Builder builder() {
    return new ImmutableProcResult.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableProcResult ImmutableProcResult}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ProcResult", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_EXIT_CODE = 0x1L;
    private static final long INIT_BIT_STD_OUTPUT = 0x2L;
    private long initBits = 0x3L;

    private int exitCode;
    private @Nullable String stdOutput;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ProcResult} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcResult instance) {
      Objects.requireNonNull(instance, "instance");
      exitCode(instance.getExitCode());
      stdOutput(instance.getStdOutput());
      return this;
    }

    /**
     * Initializes the value for the {@link ProcResult#getExitCode() exitCode} attribute.
     * @param exitCode The value for exitCode 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder exitCode(int exitCode) {
      this.exitCode = exitCode;
      initBits &= ~INIT_BIT_EXIT_CODE;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcResult#getStdOutput() stdOutput} attribute.
     * @param stdOutput The value for stdOutput 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stdOutput(String stdOutput) {
      this.stdOutput = Objects.requireNonNull(stdOutput, "stdOutput");
      initBits &= ~INIT_BIT_STD_OUTPUT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableProcResult ImmutableProcResult}.
     * @return An immutable instance of ProcResult
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableProcResult build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableProcResult(exitCode, stdOutput);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_EXIT_CODE) != 0) attributes.add("exitCode");
      if ((initBits & INIT_BIT_STD_OUTPUT) != 0) attributes.add("stdOutput");
      return "Cannot build ProcResult, some of required attributes are not set " + attributes;
    }
  }
}
