package io.jenkins.plugins.projectenv.agent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AgentInfo}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAgentInfo.builder()}.
 */
@Generated(from = "AgentInfo", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableAgentInfo implements AgentInfo {
  private final OperatingSystem operatingSystem;
  private final String lineSeparator;

  private ImmutableAgentInfo(OperatingSystem operatingSystem, String lineSeparator) {
    this.operatingSystem = operatingSystem;
    this.lineSeparator = lineSeparator;
  }

  /**
   * @return The value of the {@code operatingSystem} attribute
   */
  @Override
  public OperatingSystem getOperatingSystem() {
    return operatingSystem;
  }

  /**
   * @return The value of the {@code lineSeparator} attribute
   */
  @Override
  public String getLineSeparator() {
    return lineSeparator;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AgentInfo#getOperatingSystem() operatingSystem} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for operatingSystem
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAgentInfo withOperatingSystem(OperatingSystem value) {
    OperatingSystem newValue = Objects.requireNonNull(value, "operatingSystem");
    if (this.operatingSystem == newValue) return this;
    return new ImmutableAgentInfo(newValue, this.lineSeparator);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AgentInfo#getLineSeparator() lineSeparator} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for lineSeparator
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAgentInfo withLineSeparator(String value) {
    String newValue = Objects.requireNonNull(value, "lineSeparator");
    if (this.lineSeparator.equals(newValue)) return this;
    return new ImmutableAgentInfo(this.operatingSystem, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAgentInfo} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAgentInfo
        && equalTo(0, (ImmutableAgentInfo) another);
  }

  private boolean equalTo(int synthetic, ImmutableAgentInfo another) {
    return operatingSystem.equals(another.operatingSystem)
        && lineSeparator.equals(another.lineSeparator);
  }

  /**
   * Computes a hash code from attributes: {@code operatingSystem}, {@code lineSeparator}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + operatingSystem.hashCode();
    h += (h << 5) + lineSeparator.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AgentInfo} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AgentInfo{"
        + "operatingSystem=" + operatingSystem
        + ", lineSeparator=" + lineSeparator
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link AgentInfo} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AgentInfo instance
   */
  public static ImmutableAgentInfo copyOf(AgentInfo instance) {
    if (instance instanceof ImmutableAgentInfo) {
      return (ImmutableAgentInfo) instance;
    }
    return ImmutableAgentInfo.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAgentInfo ImmutableAgentInfo}.
   * <pre>
   * ImmutableAgentInfo.builder()
   *    .operatingSystem(io.jenkins.plugins.projectenv.agent.OperatingSystem) // required {@link AgentInfo#getOperatingSystem() operatingSystem}
   *    .lineSeparator(String) // required {@link AgentInfo#getLineSeparator() lineSeparator}
   *    .build();
   * </pre>
   * @return A new ImmutableAgentInfo builder
   */
  public static ImmutableAgentInfo.Builder builder() {
    return new ImmutableAgentInfo.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAgentInfo ImmutableAgentInfo}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AgentInfo", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_OPERATING_SYSTEM = 0x1L;
    private static final long INIT_BIT_LINE_SEPARATOR = 0x2L;
    private long initBits = 0x3L;

    private @Nullable OperatingSystem operatingSystem;
    private @Nullable String lineSeparator;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AgentInfo} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AgentInfo instance) {
      Objects.requireNonNull(instance, "instance");
      operatingSystem(instance.getOperatingSystem());
      lineSeparator(instance.getLineSeparator());
      return this;
    }

    /**
     * Initializes the value for the {@link AgentInfo#getOperatingSystem() operatingSystem} attribute.
     * @param operatingSystem The value for operatingSystem 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder operatingSystem(OperatingSystem operatingSystem) {
      this.operatingSystem = Objects.requireNonNull(operatingSystem, "operatingSystem");
      initBits &= ~INIT_BIT_OPERATING_SYSTEM;
      return this;
    }

    /**
     * Initializes the value for the {@link AgentInfo#getLineSeparator() lineSeparator} attribute.
     * @param lineSeparator The value for lineSeparator 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder lineSeparator(String lineSeparator) {
      this.lineSeparator = Objects.requireNonNull(lineSeparator, "lineSeparator");
      initBits &= ~INIT_BIT_LINE_SEPARATOR;
      return this;
    }

    /**
     * Builds a new {@link ImmutableAgentInfo ImmutableAgentInfo}.
     * @return An immutable instance of AgentInfo
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAgentInfo build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableAgentInfo(operatingSystem, lineSeparator);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_OPERATING_SYSTEM) != 0) attributes.add("operatingSystem");
      if ((initBits & INIT_BIT_LINE_SEPARATOR) != 0) attributes.add("lineSeparator");
      return "Cannot build AgentInfo, some of required attributes are not set " + attributes;
    }
  }
}
