/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipeline_keepenv_step;

import com.google.common.util.concurrent.FutureCallback;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Descriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class KeepEnvStep
extends Step {
    private final List<String> variables;

    @DataBoundConstructor
    public KeepEnvStep(List<String> variables) {
        this.variables = new ArrayList<String>(variables);
    }

    public List<String> getVariables() {
        return this.variables;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this.variables, context);
    }

    public static class Execution
    extends AbstractStepExecutionImpl {
        private static final long serialVersionUID = 1L;
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Only used when starting.")
        private final transient List<String> variables;

        Execution(List<String> variables, StepContext context) {
            super(context);
            this.variables = variables;
        }

        public boolean start() throws Exception {
            this.getContext().newBodyInvoker().withContext((Object)EnvironmentExpander.merge((EnvironmentExpander)((EnvironmentExpander)this.getContext().get(EnvironmentExpander.class)), (EnvironmentExpander)new FilteredEnvironmentExpander(this.variables))).withCallback(BodyExecutionCallback.wrap((FutureCallback)this.getContext())).start();
            return false;
        }

        public void onResume() {
        }
    }

    public static class FilteredEnvironmentExpander
    extends EnvironmentExpander {
        private static final long serialVersionUID = 1L;
        private final List<String> variables;

        public FilteredEnvironmentExpander(Collection<String> variables) {
            this.variables = new ArrayList<String>(variables);
        }

        public void expand(EnvVars env) {
            ArrayList keyList = new ArrayList(env.keySet());
            keyList.removeAll(this.variables);
            for (String key : keyList) {
                env.remove((Object)key);
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "keepEnv";
        }

        public String getDisplayName() {
            return "Keep only specified environment variables";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public Step newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String variablesToKeepS = formData.getString("variables");
            ArrayList<String> variablesToKeep = new ArrayList<String>();
            for (String line : variablesToKeepS.split("\r?\n")) {
                if ((line = line.trim()).isEmpty()) continue;
                variablesToKeep.add(line);
            }
            return new KeepEnvStep(variablesToKeep);
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.emptySet();
        }

        public String argumentsToString(Map<String, Object> namedArgs) {
            Object variablesToKeep = namedArgs.get("variables");
            if (variablesToKeep instanceof List) {
                StringBuilder b = new StringBuilder();
                for (Object variableName : (List)variablesToKeep) {
                    if (!(variableName instanceof String)) continue;
                    if (b.length() > 0) {
                        b.append(", ");
                    }
                    b.append((String)variableName);
                }
                return b.toString();
            }
            return null;
        }
    }
}

