/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipelinegraphview.utils;

import io.jenkins.plugins.pipelinegraphview.utils.CachedPipelineNodeGraphAdaptor;
import io.jenkins.plugins.pipelinegraphview.utils.FlowNodeWrapper;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineInputStep;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineState;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineStep;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineStepBuilderApi;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineStepList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.support.steps.input.InputStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineStepApi {
    private static final Logger logger = LoggerFactory.getLogger(PipelineStepApi.class);
    private final transient WorkflowRun run;

    public PipelineStepApi(WorkflowRun run) {
        this.run = run;
    }

    private List<PipelineStep> parseSteps(List<FlowNodeWrapper> stepNodes, String stageId) {
        if (logger.isDebugEnabled()) {
            logger.debug("PipelineStepApi steps: '{}'.", stepNodes);
        }
        return stepNodes.stream().map(flowNodeWrapper -> {
            String displayName = flowNodeWrapper.getDisplayName();
            String title = "";
            if (flowNodeWrapper.getType() == FlowNodeWrapper.NodeType.UNHANDLED_EXCEPTION) {
                displayName = "Pipeline error";
            } else {
                String labelDisplayName;
                String stepArguments = flowNodeWrapper.getArgumentsAsString();
                if (stepArguments != null && !stepArguments.isEmpty()) {
                    displayName = stepArguments;
                    title = flowNodeWrapper.getDisplayName();
                }
                if ((labelDisplayName = flowNodeWrapper.getLabelDisplayName()) != null && !labelDisplayName.isEmpty()) {
                    displayName = labelDisplayName;
                    title = "";
                }
            }
            logger.debug("DisplayName Before: '{}'.", (Object)displayName);
            displayName = PipelineStepApi.cleanTextContent(displayName);
            logger.debug("DisplayName After: '{}'.", (Object)displayName);
            if (!displayName.isBlank() && (title.equals("Shell Script") || title.equals("Print Message"))) {
                title = "";
            }
            return new PipelineStep(flowNodeWrapper.getId(), displayName, PipelineState.of(flowNodeWrapper.getStatus()), flowNodeWrapper.getType().name(), title, stageId, this.mapInputStep(flowNodeWrapper.getInputStep()), flowNodeWrapper.getTiming());
        }).collect(Collectors.toList());
    }

    private PipelineInputStep mapInputStep(InputStep inputStep) {
        if (inputStep == null) {
            return null;
        }
        return new PipelineInputStep(inputStep.getMessage(), inputStep.getCancel(), inputStep.getId(), inputStep.getOk(), !inputStep.getParameters().isEmpty());
    }

    static String cleanTextContent(String text) {
        text = text.replaceAll("\\e\\[(\\d+[;:]?)+m", "");
        return text.trim();
    }

    private PipelineStepList getSteps(String stageId, PipelineStepBuilderApi builder, boolean runIsComplete) {
        List<FlowNodeWrapper> stepNodes = builder.getStageSteps(stageId);
        PipelineStepList steps = new PipelineStepList(this.parseSteps(stepNodes, stageId), runIsComplete);
        steps.sort();
        return steps;
    }

    private PipelineStepList getAllSteps(PipelineStepBuilderApi builder, boolean runIsComplete) {
        Map<String, List<FlowNodeWrapper>> stepNodes = builder.getAllSteps();
        PipelineStepList allSteps = new PipelineStepList(runIsComplete);
        for (Map.Entry<String, List<FlowNodeWrapper>> entry : stepNodes.entrySet()) {
            allSteps.addAll(this.parseSteps(entry.getValue(), entry.getKey()));
        }
        allSteps.sort();
        return allSteps;
    }

    public PipelineStepList getSteps(String stageId) {
        boolean runIsComplete = !this.run.isBuilding();
        return this.getSteps(stageId, CachedPipelineNodeGraphAdaptor.instance.getFor(this.run), runIsComplete);
    }

    public PipelineStepList getAllSteps() {
        boolean runIsComplete = !this.run.isBuilding();
        return this.getAllSteps(CachedPipelineNodeGraphAdaptor.instance.getFor(this.run), runIsComplete);
    }
}

