/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipelinegraphview.consoleview;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Plugin;
import hudson.console.AnnotatedLargeText;
import hudson.model.Action;
import hudson.model.BallColor;
import hudson.model.Item;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.security.Permission;
import hudson.util.HttpResponses;
import io.jenkins.plugins.pipelinegraphview.Messages;
import io.jenkins.plugins.pipelinegraphview.PipelineGraphViewConfiguration;
import io.jenkins.plugins.pipelinegraphview.cards.RunDetailsCard;
import io.jenkins.plugins.pipelinegraphview.cards.RunDetailsItem;
import io.jenkins.plugins.pipelinegraphview.cards.items.ArtifactRunDetailsItem;
import io.jenkins.plugins.pipelinegraphview.cards.items.ChangesRunDetailsItem;
import io.jenkins.plugins.pipelinegraphview.cards.items.SCMRunDetailsItems;
import io.jenkins.plugins.pipelinegraphview.cards.items.TestResultRunDetailsItem;
import io.jenkins.plugins.pipelinegraphview.cards.items.TimingRunDetailsItems;
import io.jenkins.plugins.pipelinegraphview.cards.items.UpstreamCauseRunDetailsItem;
import io.jenkins.plugins.pipelinegraphview.cards.items.UserIdCauseRunDetailsItem;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineGraph;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineGraphApi;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineNodeUtil;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineStep;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineStepApi;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineStepList;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import org.jenkins.ui.icon.IconSpec;
import org.jenkinsci.plugins.pipeline.modeldefinition.actions.RestartDeclarativePipelineAction;
import org.jenkinsci.plugins.workflow.cps.replay.ReplayAction;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.kohsuke.stapler.verb.GET;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineConsoleViewAction
implements Action,
IconSpec {
    public static final long LOG_THRESHOLD = 153600L;
    public static final String URL_NAME = "pipeline-overview";
    public static final int CACHE_AGE = (int)TimeUnit.DAYS.toSeconds(1L);
    private static final Logger logger = LoggerFactory.getLogger(PipelineConsoleViewAction.class);
    private static final JsonConfig jsonConfig = new JsonConfig();
    private final PipelineGraphApi graphApi;
    private final WorkflowRun run;
    private final PipelineStepApi stepApi;

    public PipelineConsoleViewAction(WorkflowRun target) {
        this.run = target;
        this.graphApi = new PipelineGraphApi(this.run);
        this.stepApi = new PipelineStepApi(this.run);
    }

    public String getDisplayName() {
        return "Pipeline Overview";
    }

    public String getUrlName() {
        return URL_NAME;
    }

    @GET
    @WebMethod(name={"steps"})
    public HttpResponse getSteps(StaplerRequest2 req) {
        this.run.checkPermission(Item.READ);
        String nodeId = req.getParameter("nodeId");
        if (nodeId != null) {
            return HttpResponses.okJSON((JSONObject)this.getSteps(nodeId));
        }
        return HttpResponses.errorJSON((String)"Error getting console text");
    }

    private JSONObject getSteps(String nodeId) {
        logger.debug("getSteps was passed nodeId '{}'.", (Object)nodeId);
        PipelineStepList steps = this.stepApi.getSteps(nodeId);
        JSONObject json = JSONObject.fromObject((Object)steps, (JsonConfig)jsonConfig);
        logger.debug("Steps for {}: '{}'.", (Object)nodeId, (Object)json);
        return json;
    }

    @GET
    @WebMethod(name={"allSteps"})
    public void getAllSteps(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        this.run.checkPermission(Item.READ);
        PipelineStepList steps = this.stepApi.getAllSteps();
        JSONObject json = JSONObject.fromObject((Object)steps, (JsonConfig)jsonConfig);
        logger.debug("Steps: '{}'.", (Object)json);
        HttpResponse response = HttpResponses.okJSON((JSONObject)json);
        rsp.setStatus(200);
        this.setCache(rsp, steps.runIsComplete);
        response.generateResponse(req, rsp, null);
    }

    private void setCache(StaplerResponse2 rsp, boolean complete) {
        if (complete) {
            rsp.setHeader("Cache-Control", "private, immutable, max-age=" + CACHE_AGE);
        } else {
            rsp.setHeader("Cache-Control", "private, no-store");
        }
    }

    @WebMethod(name={"log"})
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="Doesn't seem to matter in practice, docs aren't clear on how to handle and most places ignore it")
    public void getConsoleText(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        this.run.checkPermission(Item.READ);
        String nodeId = req.getParameter("nodeId");
        rsp.setContentType("text/plain;charset=UTF-8");
        if (nodeId == null) {
            logger.error("'consoleText' was not passed 'nodeId'.");
            rsp.getWriter().write("Error getting console text\n");
            return;
        }
        logger.debug("getConsoleText was passed node id '{}'.", (Object)nodeId);
        AnnotatedLargeText<? extends FlowNode> logText = this.getLogForNode(nodeId);
        if (logText != null) {
            logText.writeLogTo(0L, (OutputStream)rsp.getOutputStream());
            return;
        }
        boolean foundLogs = false;
        PipelineStepList steps = this.stepApi.getSteps(nodeId);
        for (PipelineStep step : steps.steps) {
            logText = this.getLogForNode(step.id);
            if (logText == null) continue;
            foundLogs = true;
            logText.writeLogTo(0L, (OutputStream)rsp.getOutputStream());
        }
        if (!foundLogs) {
            rsp.getWriter().write("No logs found\n");
        }
    }

    @GET
    @WebMethod(name={"consoleBuildOutput"})
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="Doesn't seem to matter in practice, docs aren't clear on how to handle and most places ignore it")
    public void getBuildConsole(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        this.run.checkPermission(Item.READ);
        this.run.getLogText().writeHtmlTo(0L, (Writer)rsp.getWriter());
    }

    @GET
    @WebMethod(name={"exceptionText"})
    public HttpResponse getExceptionText(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        this.run.checkPermission(Item.READ);
        String nodeId = req.getParameter("nodeId");
        if (nodeId == null) {
            return HttpResponses.error((int)400, (String)"missing ?nodeId");
        }
        return HttpResponses.text((String)this.getNodeExceptionText(nodeId));
    }

    @GET
    @WebMethod(name={"consoleOutput"})
    public HttpResponse getConsoleOutput(StaplerRequest2 req) throws IOException {
        this.run.checkPermission(Item.READ);
        String nodeId = req.getParameter("nodeId");
        if (nodeId == null) {
            logger.error("'consoleJson' was not passed 'nodeId'.");
            return HttpResponses.errorJSON((String)"Error getting console json");
        }
        logger.debug("getConsoleOutput was passed node id '{}'.", (Object)nodeId);
        Long startByte = PipelineConsoleViewAction.parseIntWithDefault(req.getParameter("startByte"), -153600L);
        JSONObject data = this.getConsoleOutputJson(nodeId, startByte);
        if (data == null) {
            return HttpResponses.errorJSON((String)"Something went wrong - check Jenkins logs.");
        }
        return HttpResponses.okJSON((JSONObject)data);
    }

    protected JSONObject getConsoleOutputJson(String nodeId, Long requestStartByte) throws IOException {
        long startByte = 0L;
        long endByte = 0L;
        String text = "";
        AnnotatedLargeText<? extends FlowNode> logText = null;
        boolean nodeIsActive = false;
        FlowExecution execution = this.run.getExecution();
        if (execution != null) {
            logger.debug("getConsoleOutputJson found execution.");
            FlowNode node = execution.getNode(nodeId);
            if (node != null) {
                nodeIsActive = node.isActive();
                logText = PipelineNodeUtil.getLogText(node);
            }
        }
        if (logText != null) {
            long textLength = logText.length();
            if (requestStartByte > textLength) {
                logger.error("consoleJson - user requested startByte larger than console output.");
                return null;
            }
            if (requestStartByte < 0L) {
                logger.debug("consoleJson - requested negative startByte '{}'.", (Object)requestStartByte);
                startByte = textLength + requestStartByte;
                if (startByte < 0L) {
                    logger.debug("consoleJson - requested negative startByte '{}' out of bounds, starting at 0.", (Object)requestStartByte);
                    startByte = 0L;
                }
            } else {
                startByte = requestStartByte;
            }
            logger.debug("Returning '{}' bytes from 'getConsoleOutput'.", (Object)(textLength - startByte));
            text = PipelineNodeUtil.convertLogToString(logText, startByte);
            endByte = textLength;
        }
        JSONObject json = new JSONObject();
        json.element("text", (Object)text);
        json.element("startByte", startByte);
        json.element("endByte", endByte);
        json.element("nodeIsActive", nodeIsActive);
        return json;
    }

    private AnnotatedLargeText<? extends FlowNode> getLogForNode(String nodeId) throws IOException {
        FlowExecution execution = this.run.getExecution();
        if (execution != null) {
            logger.debug("getLogForNode found execution.");
            return PipelineNodeUtil.getLogText(execution.getNode(nodeId));
        }
        return null;
    }

    protected String getNodeExceptionText(String nodeId) throws IOException {
        FlowExecution execution = this.run.getExecution();
        if (execution != null) {
            logger.debug("getNodeException found execution.");
            return PipelineNodeUtil.getExceptionText(execution.getNode(nodeId));
        }
        return null;
    }

    private boolean isUnhandledException(String nodeId) throws IOException {
        FlowExecution execution = this.run.getExecution();
        if (execution != null) {
            return PipelineNodeUtil.isUnhandledException(execution.getNode(nodeId));
        }
        return false;
    }

    private static long parseIntWithDefault(String s, long defaultValue) {
        try {
            logger.debug("Parsing user provided value of '{}'", (Object)s);
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            logger.debug("Using default value of '{}'", (Object)defaultValue);
            return defaultValue;
        }
    }

    public RunDetailsCard getRunDetailsCard() {
        ArrayList<RunDetailsItem> runDetailsItems = new ArrayList<RunDetailsItem>(SCMRunDetailsItems.get(this.run));
        if (!runDetailsItems.isEmpty()) {
            runDetailsItems.add(RunDetailsItem.SEPARATOR);
        }
        UpstreamCauseRunDetailsItem.get(this.run).ifPresent(runDetailsItems::add);
        UserIdCauseRunDetailsItem.get(this.run).ifPresent(runDetailsItems::add);
        runDetailsItems.addAll(TimingRunDetailsItems.get(this.run));
        ChangesRunDetailsItem.get(this.run).ifPresent(runDetailsItems::add);
        TestResultRunDetailsItem.get(this.run).ifPresent(runDetailsItems::add);
        ArtifactRunDetailsItem.get(this.run).ifPresent(runDetailsItems::add);
        return new RunDetailsCard(runDetailsItems);
    }

    public boolean isShowGraphOnBuildPage() {
        return PipelineGraphViewConfiguration.get().isShowGraphOnBuildPage();
    }

    public boolean isBuildable() {
        return ((WorkflowJob)this.run.getParent()).isBuildable();
    }

    public boolean isBuildInProgress() {
        return this.run.isBuilding();
    }

    public Permission getPermission() {
        return Item.BUILD;
    }

    public Permission getCancelPermission() {
        return Item.CANCEL;
    }

    public Permission getConfigurePermission() {
        return Item.CONFIGURE;
    }

    public WorkflowRun getRun() {
        return this.run;
    }

    public String getBuildDisplayName() {
        return this.run.getDisplayName();
    }

    public String getBuildFullDisplayName() {
        return this.run.getFullDisplayName();
    }

    public boolean isRebuildAvailable() {
        Plugin rebuildPlugin = Jenkins.get().getPlugin("rebuild");
        if (rebuildPlugin != null && rebuildPlugin.getWrapper().isEnabled()) {
            return ((WorkflowJob)this.run.getParent()).getProperty(ParametersDefinitionProperty.class) != null;
        }
        return false;
    }

    public boolean isRestartFromStageAvailable() {
        RestartDeclarativePipelineAction action = (RestartDeclarativePipelineAction)this.run.getAction(RestartDeclarativePipelineAction.class);
        if (action != null) {
            return action.isRestartEnabled();
        }
        return false;
    }

    @RequirePOST
    @JavaScriptMethod
    public HttpResponse doRerun() {
        this.run.checkPermission(Item.BUILD);
        if (!((WorkflowJob)this.run.getParent()).isBuildable()) {
            return HttpResponses.errorJSON((String)Messages.scheduled_failure());
        }
        ReplayAction replayAction = (ReplayAction)this.run.getAction(ReplayAction.class);
        Queue.Item item = replayAction.run2(replayAction.getOriginalScript(), replayAction.getOriginalLoadedScripts());
        if (item == null) {
            return HttpResponses.errorJSON((String)Messages.scheduled_failure());
        }
        JSONObject obj = new JSONObject();
        obj.put("message", (Object)Messages.scheduled_success());
        obj.put("queueId", (Object)item.getId());
        return HttpResponses.okJSON((JSONObject)obj);
    }

    @GET
    @WebMethod(name={"nextBuild"})
    public HttpResponse hasNextBuild(StaplerRequest2 req) {
        this.run.checkPermission(Item.READ);
        String queueId = req.getParameter("queueId");
        if (queueId == null || queueId.isBlank()) {
            return HttpResponses.errorJSON((String)"No queueId provided");
        }
        long id = Long.parseLong(queueId);
        logger.debug("Searching for build with queueId: {}", (Object)id);
        WorkflowRun nextRun = this.findBuildByQueueId(id);
        if (nextRun == null) {
            return HttpResponses.okJSON();
        }
        JSONObject obj = new JSONObject();
        obj.put("nextBuildUrl", (Object)(nextRun.getUrl() + "pipeline-overview/"));
        return HttpResponses.okJSON((JSONObject)obj);
    }

    @CheckForNull
    private WorkflowRun findBuildByQueueId(long queueId) {
        WorkflowRun build;
        Iterator iterator = ((WorkflowJob)this.run.getParent()).getBuilds().iterator();
        while (iterator.hasNext() && (build = (WorkflowRun)iterator.next()).getNumber() > this.run.getNumber()) {
            if (build.getQueueId() != queueId) continue;
            return build;
        }
        return null;
    }

    @RequirePOST
    @JavaScriptMethod
    public HttpResponse doCancel() {
        this.run.checkPermission(this.getCancelPermission());
        if (this.run.isBuilding()) {
            this.run.doStop();
            return HttpResponses.okJSON();
        }
        String message = Result.ABORTED.equals(this.run.getResult()) ? Messages.run_alreadyCancelled() : Messages.run_isFinished();
        return HttpResponses.errorJSON((String)message);
    }

    public String getFullProjectDisplayName() {
        return ((WorkflowJob)this.run.getParent()).getFullDisplayName();
    }

    private String getBuildNumber(WorkflowRun run) {
        if (run != null) {
            return String.valueOf(run.getNumber());
        }
        return null;
    }

    public String getBuildUrl() {
        return this.run.getUrl();
    }

    public String getPreviousBuildNumber() {
        return this.getBuildNumber(this.run.getPreviousBuild());
    }

    public String getPreviousBuildUrl() {
        WorkflowRun previousBuild = this.run.getPreviousBuild();
        return previousBuild == null ? null : previousBuild.getUrl();
    }

    public String getNextBuildNumber() {
        return this.getBuildNumber(this.run.getNextBuild());
    }

    @GET
    @WebMethod(name={"tree"})
    public void getTree(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        this.run.checkPermission(Item.READ);
        PipelineGraph tree = this.graphApi.createTree();
        HttpResponse response = HttpResponses.okJSON((JSONObject)JSONObject.fromObject((Object)tree, (JsonConfig)jsonConfig));
        rsp.setStatus(200);
        this.setCache(rsp, tree.complete);
        response.generateResponse(req, rsp, null);
    }

    public String getUrl() {
        return this.run.getUrl();
    }

    public BallColor getIconColor() {
        return this.run.getIconColor();
    }

    public String getIconClassName() {
        return "symbol-git-network-outline plugin-ionicons-api";
    }

    public String getIconFileName() {
        return null;
    }

    static {
        PipelineStepList.PipelineStepListJsonProcessor.configure(jsonConfig);
        PipelineGraph.PipelineGraphJsonProcessor.configure(jsonConfig);
    }
}

