// CHECKSTYLE:OFF

package io.jenkins.plugins.pipelinegraphview;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code startedAgo}: {@code Started {0} ago}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Started {0} ago}
     */
    public static String startedAgo(Object arg0) {
        return holder.format("startedAgo", arg0);
    }

    /**
     * Key {@code startedAgo}: {@code Started {0} ago}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Started {0} ago}
     */
    public static Localizable _startedAgo(Object arg0) {
        return new Localizable(holder, "startedAgo", arg0);
    }

    /**
     * Key {@code testResults}: {@code Test results}.
     * 
     * @return
     *     {@code Test results}
     */
    public static String testResults() {
        return holder.format("testResults");
    }

    /**
     * Key {@code testResults}: {@code Test results}.
     * 
     * @return
     *     {@code Test results}
     */
    public static Localizable _testResults() {
        return new Localizable(holder, "testResults");
    }

    /**
     * Key {@code testResults.total}: {@code Total {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Total {0}}
     */
    public static String testResults_total(Object arg0) {
        return holder.format("testResults.total", arg0);
    }

    /**
     * Key {@code testResults.total}: {@code Total {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Total {0}}
     */
    public static Localizable _testResults_total(Object arg0) {
        return new Localizable(holder, "testResults.total", arg0);
    }

    /**
     * Key {@code settings.showStageName}: {@code Show stage names}.
     * 
     * @return
     *     {@code Show stage names}
     */
    public static String settings_showStageName() {
        return holder.format("settings.showStageName");
    }

    /**
     * Key {@code settings.showStageName}: {@code Show stage names}.
     * 
     * @return
     *     {@code Show stage names}
     */
    public static Localizable _settings_showStageName() {
        return new Localizable(holder, "settings.showStageName");
    }

    /**
     * Key {@code console.newTab}: {@code View step as plain text}.
     * 
     * @return
     *     {@code View step as plain text}
     */
    public static String console_newTab() {
        return holder.format("console.newTab");
    }

    /**
     * Key {@code console.newTab}: {@code View step as plain text}.
     * 
     * @return
     *     {@code View step as plain text}
     */
    public static Localizable _console_newTab() {
        return new Localizable(holder, "console.newTab");
    }

    /**
     * Key {@code queued}: {@code Queued {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Queued {0}}
     */
    public static String queued(Object arg0) {
        return holder.format("queued", arg0);
    }

    /**
     * Key {@code queued}: {@code Queued {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Queued {0}}
     */
    public static Localizable _queued(Object arg0) {
        return new Localizable(holder, "queued", arg0);
    }

    /**
     * Key {@code changes}: {@code Changes}.
     * 
     * @return
     *     {@code Changes}
     */
    public static String changes() {
        return holder.format("changes");
    }

    /**
     * Key {@code changes}: {@code Changes}.
     * 
     * @return
     *     {@code Changes}
     */
    public static Localizable _changes() {
        return new Localizable(holder, "changes");
    }

    /**
     * Key {@code testResults.passed}: {@code Passed {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Passed {0}}
     */
    public static String testResults_passed(Object arg0) {
        return holder.format("testResults.passed", arg0);
    }

    /**
     * Key {@code testResults.passed}: {@code Passed {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Passed {0}}
     */
    public static Localizable _testResults_passed(Object arg0) {
        return new Localizable(holder, "testResults.passed", arg0);
    }

    /**
     * Key {@code settings.showStageDuration}: {@code Show stage duration}.
     * 
     * @return
     *     {@code Show stage duration}
     */
    public static String settings_showStageDuration() {
        return holder.format("settings.showStageDuration");
    }

    /**
     * Key {@code settings.showStageDuration}: {@code Show stage duration}.
     * 
     * @return
     *     {@code Show stage duration}
     */
    public static Localizable _settings_showStageDuration() {
        return new Localizable(holder, "settings.showStageDuration");
    }

    /**
     * Key {@code changes.other}: {@code {0} other
     * {0,choice,1#change|1<changes}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, a number.
     * @return
     *     {@code {0} other {0,choice,1#change|1<changes}}
     */
    public static String changes_other(Object arg0) {
        return holder.format("changes.other", arg0);
    }

    /**
     * Key {@code changes.other}: {@code {0} other
     * {0,choice,1#change|1<changes}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, a number.
     * @return
     *     {@code {0} other {0,choice,1#change|1<changes}}
     */
    public static Localizable _changes_other(Object arg0) {
        return new Localizable(holder, "changes.other", arg0);
    }

    /**
     * Key {@code scheduled.success}: {@code Build scheduled}.
     * 
     * @return
     *     {@code Build scheduled}
     */
    public static String scheduled_success() {
        return holder.format("scheduled.success");
    }

    /**
     * Key {@code scheduled.success}: {@code Build scheduled}.
     * 
     * @return
     *     {@code Build scheduled}
     */
    public static Localizable _scheduled_success() {
        return new Localizable(holder, "scheduled.success");
    }

    /**
     * Key {@code scheduled.failure}: {@code Could not schedule a build}.
     * 
     * @return
     *     {@code Could not schedule a build}
     */
    public static String scheduled_failure() {
        return holder.format("scheduled.failure");
    }

    /**
     * Key {@code scheduled.failure}: {@code Could not schedule a build}.
     * 
     * @return
     *     {@code Could not schedule a build}
     */
    public static Localizable _scheduled_failure() {
        return new Localizable(holder, "scheduled.failure");
    }

    /**
     * Key {@code cause.upstream}: {@code Started by upstream pipeline {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Started by upstream pipeline {0}}
     */
    public static String cause_upstream(Object arg0) {
        return holder.format("cause.upstream", arg0);
    }

    /**
     * Key {@code cause.upstream}: {@code Started by upstream pipeline {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Started by upstream pipeline {0}}
     */
    public static Localizable _cause_upstream(Object arg0) {
        return new Localizable(holder, "cause.upstream", arg0);
    }

    /**
     * Key {@code FlowNodeWrapper.parallel}: {@code Parallel}.
     * 
     * @return
     *     {@code Parallel}
     */
    public static String FlowNodeWrapper_parallel() {
        return holder.format("FlowNodeWrapper.parallel");
    }

    /**
     * Key {@code FlowNodeWrapper.parallel}: {@code Parallel}.
     * 
     * @return
     *     {@code Parallel}
     */
    public static Localizable _FlowNodeWrapper_parallel() {
        return new Localizable(holder, "FlowNodeWrapper.parallel");
    }

    /**
     * Key {@code testResults.failed}: {@code Failed {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed {0}}
     */
    public static String testResults_failed(Object arg0) {
        return holder.format("testResults.failed", arg0);
    }

    /**
     * Key {@code testResults.failed}: {@code Failed {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed {0}}
     */
    public static Localizable _testResults_failed(Object arg0) {
        return new Localizable(holder, "testResults.failed", arg0);
    }

    /**
     * Key {@code run.isFinished}: {@code Run is already finished}.
     * 
     * @return
     *     {@code Run is already finished}
     */
    public static String run_isFinished() {
        return holder.format("run.isFinished");
    }

    /**
     * Key {@code run.isFinished}: {@code Run is already finished}.
     * 
     * @return
     *     {@code Run is already finished}
     */
    public static Localizable _run_isFinished() {
        return new Localizable(holder, "run.isFinished");
    }

    /**
     * Key {@code changes.summary}: {@code {0}
     * {0,choice,1#change|1<changes}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, a number.
     * @return
     *     {@code {0} {0,choice,1#change|1<changes}}
     */
    public static String changes_summary(Object arg0) {
        return holder.format("changes.summary", arg0);
    }

    /**
     * Key {@code changes.summary}: {@code {0}
     * {0,choice,1#change|1<changes}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, a number.
     * @return
     *     {@code {0} {0,choice,1#change|1<changes}}
     */
    public static Localizable _changes_summary(Object arg0) {
        return new Localizable(holder, "changes.summary", arg0);
    }

    /**
     * Key {@code artifacts}: {@code Artifacts}.
     * 
     * @return
     *     {@code Artifacts}
     */
    public static String artifacts() {
        return holder.format("artifacts");
    }

    /**
     * Key {@code artifacts}: {@code Artifacts}.
     * 
     * @return
     *     {@code Artifacts}
     */
    public static Localizable _artifacts() {
        return new Localizable(holder, "artifacts");
    }

    /**
     * Key {@code took}: {@code Took {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Took {0}}
     */
    public static String took(Object arg0) {
        return holder.format("took", arg0);
    }

    /**
     * Key {@code took}: {@code Took {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Took {0}}
     */
    public static Localizable _took(Object arg0) {
        return new Localizable(holder, "took", arg0);
    }

    /**
     * Key {@code settings}: {@code Settings}.
     * 
     * @return
     *     {@code Settings}
     */
    public static String settings() {
        return holder.format("settings");
    }

    /**
     * Key {@code settings}: {@code Settings}.
     * 
     * @return
     *     {@code Settings}
     */
    public static Localizable _settings() {
        return new Localizable(holder, "settings");
    }

    /**
     * Key {@code node.end}: {@code End}.
     * 
     * @return
     *     {@code End}
     */
    public static String node_end() {
        return holder.format("node.end");
    }

    /**
     * Key {@code node.end}: {@code End}.
     * 
     * @return
     *     {@code End}
     */
    public static Localizable _node_end() {
        return new Localizable(holder, "node.end");
    }

    /**
     * Key {@code noBuilds}: {@code No builds}.
     * 
     * @return
     *     {@code No builds}
     */
    public static String noBuilds() {
        return holder.format("noBuilds");
    }

    /**
     * Key {@code noBuilds}: {@code No builds}.
     * 
     * @return
     *     {@code No builds}
     */
    public static Localizable _noBuilds() {
        return new Localizable(holder, "noBuilds");
    }

    /**
     * Key {@code FlowNodeWrapper.noStage}: {@code System Generated}.
     * 
     * @return
     *     {@code System Generated}
     */
    public static String FlowNodeWrapper_noStage() {
        return holder.format("FlowNodeWrapper.noStage");
    }

    /**
     * Key {@code FlowNodeWrapper.noStage}: {@code System Generated}.
     * 
     * @return
     *     {@code System Generated}
     */
    public static Localizable _FlowNodeWrapper_noStage() {
        return new Localizable(holder, "FlowNodeWrapper.noStage");
    }

    /**
     * Key {@code testResults.skipped}: {@code Skipped {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Skipped {0}}
     */
    public static String testResults_skipped(Object arg0) {
        return holder.format("testResults.skipped", arg0);
    }

    /**
     * Key {@code testResults.skipped}: {@code Skipped {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Skipped {0}}
     */
    public static Localizable _testResults_skipped(Object arg0) {
        return new Localizable(holder, "testResults.skipped", arg0);
    }

    /**
     * Key {@code cause.user}: {@code Manually run by {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Manually run by {0}}
     */
    public static String cause_user(Object arg0) {
        return holder.format("cause.user", arg0);
    }

    /**
     * Key {@code cause.user}: {@code Manually run by {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Manually run by {0}}
     */
    public static Localizable _cause_user(Object arg0) {
        return new Localizable(holder, "cause.user", arg0);
    }

    /**
     * Key {@code node.start}: {@code Start}.
     * 
     * @return
     *     {@code Start}
     */
    public static String node_start() {
        return holder.format("node.start");
    }

    /**
     * Key {@code node.start}: {@code Start}.
     * 
     * @return
     *     {@code Start}
     */
    public static Localizable _node_start() {
        return new Localizable(holder, "node.start");
    }

    /**
     * Key {@code run.alreadyCancelled}: {@code Run was already cancelled}.
     * 
     * @return
     *     {@code Run was already cancelled}
     */
    public static String run_alreadyCancelled() {
        return holder.format("run.alreadyCancelled");
    }

    /**
     * Key {@code run.alreadyCancelled}: {@code Run was already cancelled}.
     * 
     * @return
     *     {@code Run was already cancelled}
     */
    public static Localizable _run_alreadyCancelled() {
        return new Localizable(holder, "run.alreadyCancelled");
    }

}
