/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.agent_build_history;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import hudson.util.RunList;
import io.jenkins.plugins.agent_build_history.AgentBuildHistoryConfig;
import io.jenkins.plugins.agent_build_history.AgentExecution;
import io.jenkins.plugins.agent_build_history.BuildHistoryFileManager;
import io.jenkins.plugins.agent_build_history.RunListTable;
import io.jenkins.plugins.agent_build_history.Utils;
import jakarta.servlet.http.Cookie;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.util.Timer;
import org.jenkinsci.plugins.workflow.actions.BodyInvocationAction;
import org.jenkinsci.plugins.workflow.cps.nodes.StepStartNode;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.DepthFirstScanner;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.support.actions.WorkspaceActionImpl;
import org.jenkinsci.plugins.workflow.support.steps.ExecutorStep;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;

@Restricted(value={NoExternalUse.class})
public class AgentBuildHistory
implements Action {
    private static final Logger LOGGER = Logger.getLogger(AgentBuildHistory.class.getName());
    private final Computer computer;
    private int totalPages = 1;
    private static boolean loaded = false;
    private static boolean loadingComplete = false;

    public AgentBuildHistory(Computer computer) {
        this.computer = computer;
        LOGGER.log(Level.CONFIG, () -> "Creating AgentBuildHistory for " + computer.getName());
    }

    public static String getCookieValue(StaplerRequest2 req, String name, String defaultValue) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie.getValue();
            }
        }
        return defaultValue;
    }

    private static int getRequestInteger(StaplerRequest2 req, String name, int defaultValue) {
        try {
            String value = req.getParameter(name);
            if (value == null) {
                return defaultValue;
            }
            return Integer.parseInt(req.getParameter(name));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public Computer getComputer() {
        return this.computer;
    }

    public boolean isLoadingComplete() {
        return loadingComplete;
    }

    public static void setLoaded(boolean loaded) {
        AgentBuildHistory.loaded = loaded;
        loadingComplete = loaded;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public RunListTable getHandler() {
        if (!loaded) {
            loaded = true;
            Timer.get().schedule(AgentBuildHistory::load, 0L, TimeUnit.SECONDS);
        }
        RunListTable runListTable = new RunListTable(this.computer.getName());
        StaplerRequest2 req = Stapler.getCurrentRequest2();
        int page = AgentBuildHistory.getRequestInteger(req, "page", 1);
        int pageSize = AgentBuildHistory.getRequestInteger(req, "pageSize", Integer.parseInt(AgentBuildHistory.getCookieValue(req, "pageSize", "20")));
        String sortColumn = req.getParameter("sortColumn") != null ? req.getParameter("sortColumn") : AgentBuildHistory.getCookieValue(req, "sortColumn", "startTime");
        String sortOrder = req.getParameter("sortOrder") != null ? req.getParameter("sortOrder") : AgentBuildHistory.getCookieValue(req, "sortOrder", "desc");
        String statusFilter = req.getParameter("status") != null ? req.getParameter("status") : "all";
        List<String> indexLines = BuildHistoryFileManager.readIndexFile(this.computer.getName(), AgentBuildHistoryConfig.get().getStorageDir());
        LOGGER.finer("Getting runs for node: " + this.computer.getName() + " page: " + page + " pageSize: " + pageSize + " sortColumn: " + sortColumn + " sortOrder: " + sortOrder);
        LOGGER.finer("Found " + indexLines.size() + " entries for node " + this.computer.getName());
        runListTable.setRuns(this.getExecutionsForNode(indexLines, this.computer.getName(), page, pageSize, sortColumn, sortOrder, statusFilter));
        return runListTable;
    }

    public List<AgentExecution> getExecutionsForNode(List<String> indexLines, String nodeName, int page, int pageSize, String sortColumn, String sortOrder, String statusFilter) {
        if (indexLines.isEmpty()) {
            return List.of();
        }
        indexLines.sort((a, b) -> {
            int comparison = 0;
            switch (sortColumn) {
                case "startTime": {
                    long timeA = Long.parseLong(a.split(";")[2]);
                    long timeB = Long.parseLong(b.split(";")[2]);
                    comparison = Long.compare(timeA, timeB);
                    break;
                }
                case "build": {
                    comparison = a.split(";")[0].compareTo(b.split(";")[0]);
                    if (comparison != 0) break;
                    int buildNumberA = Integer.parseInt(a.split(";")[1]);
                    int buildNumberB = Integer.parseInt(b.split(";")[1]);
                    comparison = Integer.compare(buildNumberA, buildNumberB);
                    break;
                }
            }
            return sortOrder.equals("asc") ? comparison : -comparison;
        });
        ArrayList<AgentExecution> executions = new ArrayList<AgentExecution>();
        ArrayList<Execution> filtered = new ArrayList<Execution>();
        for (String line : indexLines) {
            Result result;
            String[] parts = line.split(";");
            String jobName = parts[0];
            Job job = (Job)Jenkins.get().getItemByFullName(jobName, Job.class);
            if (job == null) continue;
            int buildNumber = Integer.parseInt(parts[1]);
            Run run = null;
            if (parts.length > 3) {
                result = Result.fromString((String)parts[3]);
            } else {
                run = job.getBuildByNumber(buildNumber);
                if (run == null) continue;
                result = run.getResult();
            }
            if (!Utils.includeRun(result, statusFilter)) continue;
            filtered.add(new Execution(job, run, buildNumber));
        }
        int start = Math.min(filtered.size(), (page - 1) * pageSize);
        int end = Math.min(start + pageSize, filtered.size());
        int totalEntries = filtered.size();
        this.totalPages = (int)Math.ceil((double)totalEntries / (double)pageSize);
        List paginated = filtered.subList(start, end);
        for (Execution exec : paginated) {
            AgentExecution execution = AgentBuildHistory.loadSingleExecution(exec);
            if (execution == null) continue;
            executions.add(execution);
        }
        LOGGER.finer("Returning " + executions.size() + " entries for node " + nodeName);
        return executions;
    }

    private static AgentExecution loadSingleExecution(Execution exec) {
        Run run = exec.run != null ? exec.run : exec.job.getBuildByNumber(exec.buildNumber);
        if (run == null) {
            LOGGER.fine("Run not found for " + exec.job.getFullName() + " #" + exec.buildNumber);
            return null;
        }
        LOGGER.finer("Loading run " + run.getFullDisplayName());
        AgentExecution execution = new AgentExecution(run);
        if (run instanceof AbstractBuild) {
            AbstractBuild build = (AbstractBuild)run;
            Node node = build.getBuiltOn();
            if (node != null) {
                LOGGER.finer("Loading AbstractBuild on node: " + node.getNodeName());
                return execution;
            }
        } else if (run instanceof WorkflowRun) {
            WorkflowRun wfr = (WorkflowRun)run;
            LOGGER.finer("Loading WorkflowRun: " + wfr.getFullDisplayName());
            FlowExecution flowExecution = wfr.getExecution();
            if (flowExecution != null) {
                block0: for (FlowNode flowNode : new DepthFirstScanner().allNodes(flowExecution)) {
                    StepStartNode startNode;
                    StepDescriptor descriptor;
                    if (!(flowNode instanceof StepStartNode) || !((descriptor = (startNode = (StepStartNode)flowNode).getDescriptor()) instanceof ExecutorStep.DescriptorImpl) || flowNode.getActions(BodyInvocationAction.class).isEmpty()) continue;
                    for (FlowNode parent : flowNode.getParents()) {
                        WorkspaceActionImpl action;
                        if (!(parent instanceof StepStartNode)) continue;
                        StepStartNode parentNode = (StepStartNode)parent;
                        StepDescriptor parentDescriptor = parentNode.getDescriptor();
                        if (!(parentDescriptor instanceof ExecutorStep.DescriptorImpl) || (action = (WorkspaceActionImpl)parentNode.getAction(WorkspaceActionImpl.class)) == null) continue block0;
                        String nodeName = action.getNode();
                        execution.addFlowNode(flowNode, nodeName);
                        LOGGER.finer("Loading WorkflowRun FlowNode on node: " + nodeName);
                        continue block0;
                    }
                }
            }
        }
        return execution;
    }

    private static void load() {
        LOGGER.log(Level.INFO, () -> "Starting to synchronize all runs");
        RunList runList = RunList.fromJobs((Iterable)Jenkins.get().allItems(Job.class));
        runList.forEach(run -> {
            WorkflowRun wfr;
            FlowExecution flowExecution;
            LOGGER.finer("Loading run " + run.getFullDisplayName());
            if (run instanceof AbstractBuild) {
                AbstractBuild build = (AbstractBuild)run;
                Node node = build.getBuiltOn();
                if (node != null) {
                    BuildHistoryFileManager.addRunToNodeIndex(node.getNodeName(), run, AgentBuildHistoryConfig.get().getStorageDir());
                }
            } else if (run instanceof WorkflowRun && (flowExecution = (wfr = (WorkflowRun)run).getExecution()) != null) {
                for (FlowNode flowNode : new DepthFirstScanner().allNodes(flowExecution)) {
                    if (!(flowNode instanceof StepStartNode)) continue;
                    StepStartNode startNode = (StepStartNode)flowNode;
                    for (WorkspaceActionImpl action : flowNode.getActions(WorkspaceActionImpl.class)) {
                        StepDescriptor descriptor = startNode.getDescriptor();
                        if (!(descriptor instanceof ExecutorStep.DescriptorImpl)) continue;
                        String nodeName = action.getNode();
                        BuildHistoryFileManager.addRunToNodeIndex(nodeName, run, AgentBuildHistoryConfig.get().getStorageDir());
                    }
                }
            }
        });
        loadingComplete = true;
        LOGGER.log(Level.INFO, () -> "Synchronizing all runs complete");
    }

    public static void startJobExecution(Computer c, Run<?, ?> run) {
        BuildHistoryFileManager.addRunToNodeIndex(c.getName(), run, AgentBuildHistoryConfig.get().getStorageDir());
    }

    public static void startFlowNodeExecution(Computer c, WorkflowRun run, FlowNode node) {
        BuildHistoryFileManager.addRunToNodeIndex(c.getName(), run, AgentBuildHistoryConfig.get().getStorageDir());
    }

    public String getIconFileName() {
        return "symbol-file-tray-stacked-outline plugin-ionicons-api";
    }

    public String getDisplayName() {
        return "Extended Build History";
    }

    public String getUrlName() {
        return "extendedBuildHistory";
    }

    private record Execution(Job<?, ?> job, Run<?, ?> run, int buildNumber) {
    }
}

