/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.onmonit.util;

import hudson.Launcher;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import io.jenkins.plugins.onmonit.util.ComputerInfo;
import java.util.Locale;
import jenkins.security.MasterToSlaveCallable;

public class RemoteComputerInfoRetriever {
    public static ComputerInfo getRemoteInfo(Launcher launcher) {
        try {
            VirtualChannel ch = launcher.getChannel();
            if (ch == null) {
                throw new IllegalArgumentException("Channel is null");
            }
            return (ComputerInfo)ch.call((Callable)new InfoCallable());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static String getOs() {
        if (RemoteComputerInfoRetriever.isWindows()) {
            return "win";
        }
        if (RemoteComputerInfoRetriever.isDarwin()) {
            return "darwin";
        }
        return "linux";
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("win");
    }

    public static boolean isDarwin() {
        String os = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        return os.contains("mac") || os.contains("darwin");
    }

    public static boolean isAmd64() {
        String arch = System.getProperty("os.arch").toLowerCase(Locale.ENGLISH);
        return arch.contains("amd64") || arch.contains("x64") || arch.contains("x86-64") || arch.contains("x86_64");
    }

    public static class InfoCallable
    extends MasterToSlaveCallable<ComputerInfo, Throwable> {
        private static final long serialVersionUID = 5982559307031083756L;

        public ComputerInfo call() throws Throwable {
            return new ComputerInfo(RemoteComputerInfoRetriever.getOs(), RemoteComputerInfoRetriever.isAmd64());
        }
    }
}

