/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.onmonit.exec;

import hudson.AbortException;
import hudson.FilePath;
import hudson.Proc;
import hudson.model.TaskListener;
import hudson.util.ArgumentListBuilder;
import io.jenkins.plugins.onmonit.LauncherProvider;
import io.jenkins.plugins.onmonit.RemoteOtelContribProcess;
import io.jenkins.plugins.onmonit.util.ComputerInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.commons.lang.StringUtils;

public class ExecRemoteOtelContribProcess
implements RemoteOtelContribProcess {
    public static final String PROC_COOKIE_NAME = "_JENKINS_PM_OTEL_COLLECTOR_COOKIE";
    protected final LauncherProvider launcherProvider;
    protected final TaskListener listener;
    protected final ComputerInfo info;
    protected final FilePath temp;
    protected final Map<String, String> envOverrides;
    protected final boolean debug;
    private final String configTmpChild;
    private FilePath executableTmpChild;
    private final ArgumentListBuilder cmd;
    private boolean started;

    ExecRemoteOtelContribProcess(LauncherProvider launcherProvider, TaskListener listener, ComputerInfo info, FilePath temp, String envCookie, String additionalOptions, boolean debug) throws Exception {
        this.launcherProvider = launcherProvider;
        this.listener = listener;
        this.info = info;
        this.temp = temp;
        HashMap<String, String> overrides = new HashMap<String, String>();
        overrides.put(PROC_COOKIE_NAME, envCookie);
        this.envOverrides = overrides;
        this.debug = debug;
        FilePath configFile = temp.createTempFile("otel", ".yaml");
        this.configTmpChild = configFile.getName();
        this.cmd = this.getCmd();
        if (StringUtils.isNotBlank((String)additionalOptions)) {
            this.cmd.addTokenized(additionalOptions);
        }
        this.cmd.add("--config=file:" + configFile.getRemote());
    }

    @Override
    public void start(TaskListener listener, String config) throws IOException, InterruptedException {
        this.started = true;
        FilePath configFile = this.temp.child(this.configTmpChild);
        configFile.write(config, StandardCharsets.UTF_8.name());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Proc proc = this.launcherProvider.getLauncher().launch().cmds(this.cmd).envs(this.envOverrides).stdout((OutputStream)(this.debug ? new TeeOutputStream((OutputStream)listener.getLogger(), (OutputStream)baos) : baos)).stderr((OutputStream)(this.debug ? new TeeOutputStream((OutputStream)listener.getLogger(), (OutputStream)baos) : baos)).start();
        Instant timeout = Instant.now().plus(1L, ChronoUnit.MINUTES);
        while (proc.isAlive() && Instant.now().isBefore(timeout)) {
            String output = baos.toString(StandardCharsets.UTF_8);
            if (output.contains("Everything is ready.")) {
                return;
            }
            Thread.sleep(100L);
        }
        if (proc.isAlive()) {
            if (!this.debug) {
                listener.getLogger().println("Failed to start otelcol-contrib, timeout after 1 minute: " + String.valueOf(baos));
            }
            throw new AbortException("Failed to start otelcol-contrib, timeout after 1 minute");
        }
        if (!this.debug) {
            listener.getLogger().println("Failed to start otelcol-contrib: " + String.valueOf(baos));
        }
        throw new AbortException("Failed to start otelcol-contrib");
    }

    protected ArgumentListBuilder getCmd() throws IOException, InterruptedException {
        return new ArgumentListBuilder(new String[]{"win".equals(this.info.getOs()) ? "otelcol-contrib.exe" : "otelcol-contrib"});
    }

    protected FilePath createTempExecutableFile() throws IOException, InterruptedException {
        FilePath result = "win".equals(this.info.getOs()) ? this.temp.createTempFile("otelcol-contrib", "exe") : this.temp.createTempFile("otelcol-contrib", "");
        this.executableTmpChild = result;
        return result;
    }

    @Override
    public void stop(TaskListener listener) throws IOException, InterruptedException {
        if (this.started) {
            this.launcherProvider.getLauncher().kill(this.envOverrides);
            this.started = false;
        }
        this.temp.child(this.configTmpChild).delete();
        if (this.executableTmpChild != null) {
            this.executableTmpChild.delete();
        }
    }
}

