/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.onmonit.exec;

import hudson.AbortException;
import hudson.FilePath;
import hudson.Proc;
import hudson.model.TaskListener;
import hudson.util.ArgumentListBuilder;
import io.jenkins.plugins.onmonit.LauncherProvider;
import io.jenkins.plugins.onmonit.RemoteNodeExporterProcess;
import io.jenkins.plugins.onmonit.util.ComputerInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.commons.lang.StringUtils;

public class ExecRemoteNodeExporterProcess
implements RemoteNodeExporterProcess {
    public static final String PROC_COOKIE_NAME = "_JENKINS_PM_NODE_EXPORTER_COOKIE";
    protected final LauncherProvider launcherProvider;
    protected final TaskListener listener;
    protected final ComputerInfo info;
    protected final FilePath temp;
    private final Map<String, String> envOverrides;
    protected final boolean debug;
    private FilePath executableTmpChild;
    private final ArgumentListBuilder cmd;
    private boolean started;

    ExecRemoteNodeExporterProcess(LauncherProvider launcherProvider, TaskListener listener, ComputerInfo info, FilePath temp, String envCookie, String additionalOptions, boolean debug) throws Exception {
        this.launcherProvider = launcherProvider;
        this.listener = listener;
        this.info = info;
        this.temp = temp;
        HashMap<String, String> overrides = new HashMap<String, String>();
        overrides.put(PROC_COOKIE_NAME, envCookie);
        this.envOverrides = overrides;
        this.debug = debug;
        this.cmd = this.getCmd();
        if (StringUtils.isNotBlank((String)additionalOptions)) {
            this.cmd.addTokenized(additionalOptions);
        }
        this.cmd.add("--web.disable-exporter-metrics");
    }

    @Override
    public void start(TaskListener listener, int port) throws IOException, InterruptedException {
        this.started = true;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.cmd.add("--web.listen-address=:" + port);
        Proc proc = this.launcherProvider.getLauncher().launch().cmds(this.cmd).envs(this.envOverrides).stdout((OutputStream)(this.debug ? new TeeOutputStream((OutputStream)listener.getLogger(), (OutputStream)baos) : baos)).stderr((OutputStream)(this.debug ? new TeeOutputStream((OutputStream)listener.getLogger(), (OutputStream)baos) : baos)).start();
        Instant timeout = Instant.now().plus(1L, ChronoUnit.MINUTES);
        String strPort = Integer.toString(port);
        while (proc.isAlive() && Instant.now().isBefore(timeout)) {
            String output = baos.toString(StandardCharsets.UTF_8);
            if (output.contains("Listening on") && output.contains(strPort)) {
                return;
            }
            Thread.sleep(100L);
        }
        if (proc.isAlive()) {
            if (!this.debug) {
                listener.getLogger().println("Failed to start node_exporter, timeout after 1 minute: " + String.valueOf(baos));
            }
            throw new AbortException("Failed to start node_exporter, timeout after 1 minute");
        }
        if (!this.debug) {
            listener.getLogger().println("Failed to start node_exporter: " + String.valueOf(baos));
        }
        throw new AbortException("Failed to start node_exporter");
    }

    protected ArgumentListBuilder getCmd() throws IOException, InterruptedException {
        return new ArgumentListBuilder(new String[]{"win".equals(this.info.getOs()) ? "windows_exporter.exe" : "node_exporter"});
    }

    protected FilePath createTempExecutableFile() throws IOException, InterruptedException {
        FilePath result = "win".equals(this.info.getOs()) ? this.temp.createTempFile("windows_exporter", "exe") : this.temp.createTempFile("node_exporter", "");
        this.executableTmpChild = result;
        return result;
    }

    @Override
    public void stop(TaskListener listener) throws IOException, InterruptedException {
        if (this.started) {
            this.launcherProvider.getLauncher().kill(this.envOverrides);
            this.started = false;
        }
        if (this.executableTmpChild != null) {
            this.executableTmpChild.delete();
        }
    }
}

