/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.openmfa;

import hudson.Extension;
import hudson.model.ManagementLink;
import hudson.model.User;
import hudson.security.Permission;
import io.jenkins.plugins.openmfa.base.MFAContext;
import io.jenkins.plugins.openmfa.service.UserService;
import io.jenkins.plugins.openmfa.service.model.UserInfo;
import io.jenkins.plugins.openmfa.util.JenkinsUtil;
import io.jenkins.plugins.openmfa.util.SecurityUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import lombok.Generated;
import org.kohsuke.stapler.Header;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class MFAManagementLink
extends ManagementLink {
    @Generated
    private static final Logger log = Logger.getLogger(MFAManagementLink.class.getName());

    @RequirePOST
    public HttpResponse doResetMFA(@QueryParameter String userId, @Header(value="X-Requested-With") String requestedWith) {
        this.checkAdminPermission();
        if (userId == null || userId.trim().isEmpty()) {
            return HttpResponses.error((int)400, (String)"User ID is required");
        }
        User user = User.getById((String)userId, (boolean)false);
        if (user == null) {
            return HttpResponses.error((int)404, (String)("User not found: " + userId));
        }
        try {
            UserService userService = MFAContext.i().getService(UserService.class);
            userService.resetMFA(user);
            log.info(String.format("Admin reset MFA for user: %s", userId));
            if ("XMLHttpRequest".equals(requestedWith)) {
                return HttpResponses.ok();
            }
            return HttpResponses.redirectTo((String)(".?success=reset_mfa&user_id=" + userId));
        }
        catch (IOException e) {
            log.severe(String.format("Failed to reset MFA for user %s: %s", userId, e.getMessage()));
            return HttpResponses.error((int)500, (String)("Failed to reset MFA: " + e.getMessage()));
        }
    }

    @RequirePOST
    public HttpResponse doSetMFA(@QueryParameter String userId) {
        this.checkAdminPermission();
        if (userId == null || userId.trim().isEmpty()) {
            return HttpResponses.error((int)400, (String)"User ID is required");
        }
        User user = User.getById((String)userId, (boolean)false);
        if (user == null) {
            return HttpResponses.error((int)404, (String)("User not found: " + userId));
        }
        return HttpResponses.redirectTo((String)SecurityUtil.buildSetupURI(Stapler.getCurrentRequest2().getContextPath(), userId));
    }

    public Collection<UserInfo> getAllUsers() {
        this.checkAdminPermission();
        UserService userService = MFAContext.i().getService(UserService.class);
        return userService.getAllUsersWithMFAStatus();
    }

    public ManagementLink.Category getCategory() {
        return ManagementLink.Category.SECURITY;
    }

    public String getDescription() {
        return "View and manage MFA status for all users";
    }

    public String getDisplayName() {
        return "MFA User Management";
    }

    public long getEnabledCount() {
        this.checkAdminPermission();
        UserService userService = MFAContext.i().getService(UserService.class);
        return userService.getEnabledMFACount();
    }

    public String getIconFileName() {
        return "symbol-id-card";
    }

    public Permission getRequiredPermission() {
        return Jenkins.ADMINISTER;
    }

    public String getSetupUri(String userId) {
        return SecurityUtil.buildSetupURI(Stapler.getCurrentRequest2().getContextPath(), userId);
    }

    public long getTotalCount() {
        this.checkAdminPermission();
        UserService userService = MFAContext.i().getService(UserService.class);
        return userService.getTotalUserCount();
    }

    public String getUrlName() {
        return "mfa-management";
    }

    private void checkAdminPermission() {
        JenkinsUtil.checkAdminPermission();
    }
}

