/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.github.api.mock;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jenkins.plugins.github.api.mock.MockGitHub;
import jenkins.plugins.github.api.mock.MockObject;
import jenkins.plugins.github.api.mock.MockRepository;

public abstract class MockOwner<T>
extends MockObject {
    private final Map<String, MockRepository> repositories = new HashMap<String, MockRepository>();
    private final String login;
    private String name;
    private String avatarUrl;
    private String blog;
    private String location;
    private String email;
    private Set<String> following = new HashSet<String>();

    MockOwner(MockGitHub app, String login) {
        super(app);
        this.login = login;
    }

    public Map<String, MockRepository> repositories() {
        return this.repositories;
    }

    public T withPublicRepo(String name) {
        return this.withRepo(name, false);
    }

    public T withPrivateRepo(String name) {
        return this.withRepo(name, true);
    }

    public T withRepo(String name, boolean isPrivate) {
        MockRepository repo = new MockRepository(this.app(), this, name).withPrivate(isPrivate);
        this.repositories.put(name, repo);
        return (T)this;
    }

    public String getLogin() {
        return this.login;
    }

    public String getName() {
        return this.name;
    }

    public T withName(String name) {
        this.name = name;
        this.touch();
        return (T)this;
    }

    public abstract String getType();

    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public T withAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
        this.touch();
        return (T)this;
    }

    public String getBlog() {
        return this.blog;
    }

    public T withBlog(String blog) {
        this.blog = blog;
        this.touch();
        return (T)this;
    }

    public String getLocation() {
        return this.location;
    }

    public T withLocation(String location) {
        this.location = location;
        this.touch();
        return (T)this;
    }

    public String getEmail() {
        return this.email;
    }

    public T withEmail(String email) {
        this.email = email;
        this.touch();
        return (T)this;
    }

    public int getPublicRepos() {
        int result = 0;
        for (MockRepository r : this.repositories.values()) {
            if (r.isPrivate()) continue;
            ++result;
        }
        return result;
    }

    public int getFollowers() {
        int count = 0;
        for (MockOwner<?> owner : this.app().owners()) {
            if (!owner.following.contains(this.login)) continue;
            ++count;
        }
        return 0;
    }

    public int getFollowing() {
        return this.following.size();
    }

    public T withFollowing(Set<String> following) {
        this.following = following;
        this.touch();
        return (T)this;
    }
}

