/*
 * Decompiled with CFR 0.152.
 */
package io.notifer.jenkins;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.notifer.jenkins.NotiferClient;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class NotiferStep
extends Step
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String credentialsId;
    private final String topic;
    private String message;
    private String title;
    private int priority = 0;
    private String tags;
    private boolean failOnError = false;

    @DataBoundConstructor
    public NotiferStep(@NonNull String credentialsId, @NonNull String topic) {
        this.credentialsId = credentialsId;
        this.topic = topic;
    }

    @NonNull
    public String getCredentialsId() {
        return this.credentialsId;
    }

    @NonNull
    public String getTopic() {
        return this.topic;
    }

    public String getMessage() {
        return this.message;
    }

    public String getTitle() {
        return this.title;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getTags() {
        return this.tags;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    @DataBoundSetter
    public void setMessage(String message) {
        this.message = message;
    }

    @DataBoundSetter
    public void setTitle(String title) {
        this.title = title;
    }

    @DataBoundSetter
    public void setPriority(int priority) {
        this.priority = Math.max(0, Math.min(5, priority));
    }

    @DataBoundSetter
    public void setTags(Object tags) {
        List tagList;
        this.tags = tags == null ? null : (tags instanceof List ? (!(tagList = (List)tags).isEmpty() ? tagList.stream().map(Object::toString).collect(Collectors.joining(",")) : null) : tags.toString());
    }

    @DataBoundSetter
    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new NotiferStepExecution(this, context);
    }

    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Step execution is synchronous and completes immediately, no serialization needed")
    private static class NotiferStepExecution
    extends SynchronousNonBlockingStepExecution<NotiferClient.NotiferResponse> {
        private static final long serialVersionUID = 1L;
        private final transient NotiferStep step;

        NotiferStepExecution(NotiferStep step, StepContext context) {
            super(context);
            this.step = step;
        }

        protected NotiferClient.NotiferResponse run() throws Exception {
            TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
            Run run = (Run)this.getContext().get(Run.class);
            EnvVars envVars = (EnvVars)this.getContext().get(EnvVars.class);
            PrintStream logger = listener.getLogger();
            Result result = run.getResult();
            String token = this.getTokenFromCredentials(this.step.credentialsId, (Item)run.getParent());
            if (token == null || token.isEmpty()) {
                throw new IllegalArgumentException("Could not retrieve token from credentials: " + this.step.credentialsId);
            }
            String topic = envVars.expand(this.step.topic);
            String message = this.step.message;
            message = message == null || message.isEmpty() ? this.buildDefaultMessage(run, result) : envVars.expand(message);
            String title = this.step.title;
            title = title == null || title.isEmpty() ? this.buildDefaultTitle(run, result) : envVars.expand(title);
            int priority = this.step.priority > 0 ? this.step.priority : this.getPriorityForResult(result);
            List<String> tags = this.parseTags(this.step.tags, result, envVars);
            logger.println("[Notifer] Sending notification to topic: " + topic);
            try {
                NotiferClient client = new NotiferClient(token);
                NotiferClient.NotiferResponse response = client.send(topic, message, title, priority, tags);
                logger.println("[Notifer] Notification sent successfully. ID: " + response.getId());
                return response;
            }
            catch (NotiferClient.NotiferException e) {
                String errorMessage = "[Notifer] Failed to send notification: " + e.getMessage();
                if (this.step.failOnError) {
                    throw new RuntimeException(errorMessage, e);
                }
                logger.println(errorMessage);
                return null;
            }
        }

        private String getTokenFromCredentials(String credentialsId, Item item) {
            StringCredentials credentials = (StringCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StringCredentials.class, (Item)item, (Authentication)(item instanceof Queue.Task ? ((Queue.Task)item).getDefaultAuthentication() : ACL.SYSTEM), Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
            return credentials != null ? credentials.getSecret().getPlainText() : null;
        }

        @SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"}, justification="Intentional \\n for notification message format, not console output")
        private String buildDefaultMessage(Run<?, ?> run, Result result) {
            String jobName = run.getParent().getFullDisplayName();
            int buildNumber = run.getNumber();
            String status = result != null ? result.toString() : "RUNNING";
            String url = Jenkins.get().getRootUrl() + run.getUrl();
            return String.format("Build #%d %s\nJob: %s\nDetails: %s", buildNumber, status, jobName, url);
        }

        private String buildDefaultTitle(Run<?, ?> run, Result result) {
            String jobName = run.getParent().getDisplayName();
            String status = result != null ? result.toString() : "RUNNING";
            return String.format("[%s] %s #%d", status, jobName, run.getNumber());
        }

        private int getPriorityForResult(Result result) {
            if (result == null || result == Result.SUCCESS) {
                return 2;
            }
            if (result == Result.UNSTABLE) {
                return 3;
            }
            if (result == Result.FAILURE) {
                return 5;
            }
            return 3;
        }

        private List<String> parseTags(String tagsString, Result result, EnvVars envVars) {
            List<String> tagList = new ArrayList<String>();
            if (result != null) {
                tagList.add(result.toString().toLowerCase());
            }
            tagList.add("jenkins");
            if (tagsString != null && !tagsString.isEmpty()) {
                String[] parts;
                String expanded = envVars.expand(tagsString);
                for (String part : parts = expanded.split("[,\\s]+")) {
                    String trimmed = part.trim();
                    if (trimmed.isEmpty() || tagList.size() >= 5) continue;
                    tagList.add(trimmed);
                }
            }
            if (tagList.size() > 5) {
                tagList = tagList.subList(0, 5);
            }
            return tagList;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return new HashSet<Class>(Arrays.asList(Run.class, TaskListener.class, EnvVars.class));
        }

        public String getFunctionName() {
            return "notifer";
        }

        @NonNull
        public String getDisplayName() {
            return "Send Notifer Notification";
        }

        @POST
        public FormValidation doCheckPriority(@QueryParameter int value) {
            if (value < 0 || value > 5) {
                return FormValidation.warning((String)"Priority should be 0 (auto) or between 1 and 5");
            }
            return FormValidation.ok();
        }

        @POST
        public ListBoxModel doFillPriorityItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Auto (based on result)", "0");
            items.add("1 - Minimum", "1");
            items.add("2 - Low", "2");
            items.add("3 - Default", "3");
            items.add("4 - High", "4");
            items.add("5 - Maximum", "5");
            return items;
        }

        @POST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String credentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(credentialsId);
            }
            return result.includeEmptyValue().includeMatchingAs(item instanceof Queue.Task ? ((Queue.Task)item).getDefaultAuthentication() : ACL.SYSTEM, item, StringCredentials.class, Collections.emptyList(), CredentialsMatchers.always()).includeCurrentValue(credentialsId);
        }
    }
}

