/*
 * Decompiled with CFR 0.152.
 */
package io.notifer.jenkins;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.notifer.jenkins.NotiferClient;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class NotiferNotifier
extends Notifier
implements SimpleBuildStep {
    private final String credentialsId;
    private final String topic;
    private String message;
    private String title;
    private int priority = 0;
    private String tags;
    private boolean notifySuccess = true;
    private boolean notifyFailure = true;
    private boolean notifyUnstable = true;
    private boolean notifyAborted = false;

    @DataBoundConstructor
    public NotiferNotifier(@NonNull String credentialsId, @NonNull String topic) {
        this.credentialsId = credentialsId;
        this.topic = topic;
    }

    @NonNull
    public String getCredentialsId() {
        return this.credentialsId;
    }

    @NonNull
    public String getTopic() {
        return this.topic;
    }

    public String getMessage() {
        return this.message;
    }

    public String getTitle() {
        return this.title;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getTags() {
        return this.tags;
    }

    public boolean isNotifySuccess() {
        return this.notifySuccess;
    }

    public boolean isNotifyFailure() {
        return this.notifyFailure;
    }

    public boolean isNotifyUnstable() {
        return this.notifyUnstable;
    }

    public boolean isNotifyAborted() {
        return this.notifyAborted;
    }

    @DataBoundSetter
    public void setMessage(String message) {
        this.message = message;
    }

    @DataBoundSetter
    public void setTitle(String title) {
        this.title = title;
    }

    @DataBoundSetter
    public void setPriority(int priority) {
        this.priority = Math.max(0, Math.min(5, priority));
    }

    @DataBoundSetter
    public void setTags(Object tags) {
        List tagList;
        this.tags = tags == null ? null : (tags instanceof List ? (!(tagList = (List)tags).isEmpty() ? tagList.stream().map(Object::toString).collect(Collectors.joining(",")) : null) : tags.toString());
    }

    @DataBoundSetter
    public void setNotifySuccess(boolean notifySuccess) {
        this.notifySuccess = notifySuccess;
    }

    @DataBoundSetter
    public void setNotifyFailure(boolean notifyFailure) {
        this.notifyFailure = notifyFailure;
    }

    @DataBoundSetter
    public void setNotifyUnstable(boolean notifyUnstable) {
        this.notifyUnstable = notifyUnstable;
    }

    @DataBoundSetter
    public void setNotifyAborted(boolean notifyAborted) {
        this.notifyAborted = notifyAborted;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull EnvVars envVars, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException, IOException {
        PrintStream logger = listener.getLogger();
        Result result = run.getResult();
        if (!this.shouldNotify(result)) {
            logger.println("[Notifer] Skipping notification for result: " + String.valueOf(result));
            return;
        }
        String token = this.getTokenFromCredentials(this.credentialsId, (Item)run.getParent());
        if (token == null || token.isEmpty()) {
            logger.println("[Notifer] ERROR: Could not retrieve token from credentials: " + this.credentialsId);
            return;
        }
        String resolvedTopic = envVars.expand(this.topic);
        String resolvedMessage = this.message;
        resolvedMessage = resolvedMessage == null || resolvedMessage.isEmpty() ? this.buildDefaultMessage(run, result) : envVars.expand(resolvedMessage);
        String resolvedTitle = this.title;
        resolvedTitle = resolvedTitle == null || resolvedTitle.isEmpty() ? this.buildDefaultTitle(run, result) : envVars.expand(resolvedTitle);
        int resolvedPriority = this.priority > 0 ? this.priority : this.getPriorityForResult(result);
        List<String> tagList = this.parseTags(this.tags, result, envVars);
        logger.println("[Notifer] Sending notification to topic: " + resolvedTopic);
        logger.println("[Notifer] Message: " + resolvedMessage.replace("\n", "\\n").replace("\r", "\\r"));
        try {
            NotiferClient client = new NotiferClient(token);
            NotiferClient.NotiferResponse response = client.send(resolvedTopic, resolvedMessage, resolvedTitle, resolvedPriority, tagList);
            logger.println("[Notifer] Notification sent successfully. ID: " + response.getId());
        }
        catch (NotiferClient.NotiferException e) {
            logger.println("[Notifer] Failed to send notification: " + e.getMessage());
        }
    }

    private String getTokenFromCredentials(String credentialsId, Item item) {
        StringCredentials credentials = (StringCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StringCredentials.class, (Item)item, (Authentication)(item instanceof Queue.Task ? ((Queue.Task)item).getDefaultAuthentication() : ACL.SYSTEM), Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
        return credentials != null ? credentials.getSecret().getPlainText() : null;
    }

    private boolean shouldNotify(Result result) {
        if (result == null) {
            return this.notifySuccess;
        }
        if (result == Result.SUCCESS) {
            return this.notifySuccess;
        }
        if (result == Result.FAILURE) {
            return this.notifyFailure;
        }
        if (result == Result.UNSTABLE) {
            return this.notifyUnstable;
        }
        if (result == Result.ABORTED) {
            return this.notifyAborted;
        }
        return true;
    }

    @SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"}, justification="Intentional \\n for notification message format, not console output")
    private String buildDefaultMessage(Run<?, ?> run, Result result) {
        String jobName = run.getParent().getFullDisplayName();
        int buildNumber = run.getNumber();
        String status = result != null ? result.toString() : "RUNNING";
        String url = Jenkins.get().getRootUrl() + run.getUrl();
        return String.format("Build #%d %s\nJob: %s\nDetails: %s", buildNumber, status, jobName, url);
    }

    private String buildDefaultTitle(Run<?, ?> run, Result result) {
        String jobName = run.getParent().getDisplayName();
        String status = result != null ? result.toString() : "RUNNING";
        return String.format("[%s] %s #%d", status, jobName, run.getNumber());
    }

    private int getPriorityForResult(Result result) {
        if (result == null || result == Result.SUCCESS) {
            return 2;
        }
        if (result == Result.UNSTABLE) {
            return 3;
        }
        if (result == Result.FAILURE) {
            return 5;
        }
        return 3;
    }

    private List<String> parseTags(String tagsString, Result result, EnvVars envVars) {
        List<String> tagList = new ArrayList<String>();
        if (result != null) {
            tagList.add(result.toString().toLowerCase());
        }
        tagList.add("jenkins");
        if (tagsString != null && !tagsString.isEmpty()) {
            String[] parts;
            String expanded = envVars.expand(tagsString);
            for (String part : parts = expanded.split("[,\\s]+")) {
                String trimmed = part.trim();
                if (trimmed.isEmpty() || tagList.size() >= 5) continue;
                tagList.add(trimmed);
            }
        }
        if (tagList.size() > 5) {
            tagList = tagList.subList(0, 5);
        }
        return tagList;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        @NonNull
        public String getDisplayName() {
            return "Send Notifer Notification";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        @POST
        public FormValidation doCheckPriority(@QueryParameter int value) {
            if (value < 0 || value > 5) {
                return FormValidation.warning((String)"Priority should be 0 (auto) or between 1 and 5");
            }
            return FormValidation.ok();
        }

        @POST
        public ListBoxModel doFillPriorityItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("Auto (based on result)", "0");
            items.add("1 - Minimum", "1");
            items.add("2 - Low", "2");
            items.add("3 - Default", "3");
            items.add("4 - High", "4");
            items.add("5 - Maximum", "5");
            return items;
        }

        @POST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String credentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(credentialsId);
            }
            return result.includeEmptyValue().includeMatchingAs(item instanceof Queue.Task ? ((Queue.Task)item).getDefaultAuthentication() : ACL.SYSTEM, item, StringCredentials.class, Collections.emptyList(), CredentialsMatchers.always()).includeCurrentValue(credentialsId);
        }
    }
}

