/*
 * Decompiled with CFR 0.152.
 */
package io.notifer.jenkins;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import hudson.ProxyConfiguration;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

public class NotiferClient
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(NotiferClient.class.getName());
    private static final int TIMEOUT_SECONDS = 30;
    private static final Gson GSON = new GsonBuilder().create();
    public static final String API_URL = "https://app.notifer.io";
    private final String token;

    public NotiferClient(String token) {
        this.token = token;
    }

    public NotiferResponse send(String topic, String message, String title, int priority, List<String> tags) throws NotiferException {
        String url = "https://app.notifer.io/" + topic;
        Map<String, Object> payload = this.buildPayload(message, title, priority, tags);
        LOGGER.log(Level.FINE, "Sending notification to {0}", url);
        try {
            HttpClient client = this.getHttpClient();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).timeout(Duration.ofSeconds(30L)).header("Content-Type", "application/json").header("X-Topic-Token", this.token).POST(HttpRequest.BodyPublishers.ofString(GSON.toJson(payload))).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            int statusCode = response.statusCode();
            String responseBody = response.body();
            if (statusCode >= 200 && statusCode < 300) {
                LOGGER.log(Level.FINE, "Notification sent successfully: {0}", responseBody);
                return (NotiferResponse)GSON.fromJson(responseBody, NotiferResponse.class);
            }
            String errorMessage = String.format("Notifer API returned status %d: %s", statusCode, responseBody);
            LOGGER.log(Level.WARNING, errorMessage);
            throw new NotiferException(errorMessage, statusCode);
        }
        catch (IOException | InterruptedException e) {
            String errorMessage = "Failed to send notification: " + e.getMessage();
            LOGGER.log(Level.SEVERE, errorMessage, e);
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new NotiferException(errorMessage, e);
        }
    }

    private HttpClient getHttpClient() {
        ProxyConfiguration proxy;
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins != null && (proxy = jenkins.proxy) != null) {
            return proxy.newHttpClient();
        }
        return HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(30L)).followRedirects(HttpClient.Redirect.NORMAL).build();
    }

    private Map<String, Object> buildPayload(String message, String title, int priority, List<String> tags) {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("message", message);
        if (title != null && !title.isEmpty()) {
            payload.put("title", title);
        }
        priority = Math.max(1, Math.min(5, priority));
        payload.put("priority", priority);
        if (tags != null && !tags.isEmpty()) {
            payload.put("tags", tags);
        }
        return payload;
    }

    public static class NotiferResponse
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String id;
        private String topic;
        private String message;
        private int priority;
        private List<String> tags;

        public String getId() {
            return this.id;
        }

        public String getTopic() {
            return this.topic;
        }

        public String getMessage() {
            return this.message;
        }

        public int getPriority() {
            return this.priority;
        }

        public List<String> getTags() {
            return this.tags;
        }

        public String toString() {
            return String.format("NotiferResponse{id='%s', topic='%s', priority=%d}", this.id, this.topic, this.priority);
        }
    }

    public static class NotiferException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final int statusCode;

        public NotiferException(String message, int statusCode) {
            super(message);
            this.statusCode = statusCode;
        }

        public NotiferException(String message, Throwable cause) {
            super(message, cause);
            this.statusCode = -1;
        }

        public int getStatusCode() {
            return this.statusCode;
        }
    }
}

