package io.jenkins.plugins.neuvector;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;

import org.apache.http.conn.ssl.DefaultHostnameVerifier;

/**
 * Custom hostname verifier implementation that delegates to the
 * DefaultHostnameVerifier, but will allow a particular set of hosts
 * through even if the delegate verifier fails.
 */
public class WhitelistedHostnameVerifier implements HostnameVerifier {

    private final DefaultHostnameVerifier delegate = new DefaultHostnameVerifier();
    private final String whitelistHost;

    public WhitelistedHostnameVerifier(String hostname) {
        this.whitelistHost = hostname;
    }

    @Override
    public boolean verify(String host, SSLSession session){
        boolean result = delegate.verify(host, session);
        if (!result) {
            return whitelistHost.equals(host);
        }
        return true;
    }

}
