package io.jenkins.plugins.neuvector;

import hudson.model.Action;
import hudson.model.Run;

public class NeuVectorAction implements Action {

    private Run<?, ?> run;
    private String artifact;
    private String reportNumber;

    public NeuVectorAction(Run<?, ?> run, String artifact, String reportNumber) {
        this.run = run;
        this.artifact = artifact;
        this.reportNumber = reportNumber;
    }

    @Override
    public String getIconFileName() {
        return "/plugin/neuvector-vulnerability-scanner/images/neuvector.png";
    }

    @Override
    public String getDisplayName() {
        return Messages.NeuVectorAction_DisplayName() + " " + reportNumber;
    }

    @Override
    public String getUrlName() {
        return "neuvector-report-" + reportNumber;
    }

    public Run<?, ?> getBuild() {
        return run;
    }

    public String getResultsUrl() {
        return "../artifact/" + artifact;
    }
}