/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.reporter.util;

import com.google.errorprone.annotations.FormatMethod;
import hudson.model.TaskListener;
import io.jenkins.plugins.reporter.model.Report;
import io.jenkins.plugins.util.PluginLogger;
import java.util.List;

public class LogHandler {
    private final PluginLogger errorLogger;
    private final PluginLogger logger;
    private int infoPosition = 0;
    private int errorPosition = 0;

    public LogHandler(TaskListener listener, String name) {
        this(listener, name, 0, 0);
    }

    public LogHandler(TaskListener listener, String name, Report report) {
        this(listener, name, report.getInfoMessages().size(), report.getErrorMessages().size());
    }

    private LogHandler(TaskListener listener, String name, int infoPosition, int errorPosition) {
        this.logger = this.createLogger(listener, name);
        this.errorLogger = this.createErrorLogger(listener, name);
        this.infoPosition = infoPosition;
        this.errorPosition = errorPosition;
    }

    private PluginLogger createErrorLogger(TaskListener listener, String name) {
        return this.createLogger(listener, String.format("[%s] [-ERROR-]", name));
    }

    private PluginLogger createLogger(TaskListener listener, String name) {
        return new PluginLogger(listener.getLogger(), name);
    }

    public void log(Report report) {
        this.logErrorMessages(report);
        this.logInfoMessages(report);
    }

    @FormatMethod
    public void log(String format, Object ... args) {
        this.logger.log(format, args);
    }

    private void logErrorMessages(Report report) {
        List<String> errorMessages = report.getErrorMessages();
        if (this.errorPosition < errorMessages.size()) {
            this.errorLogger.logEachLine(errorMessages.subList(this.errorPosition, errorMessages.size()));
            this.errorPosition = errorMessages.size();
        }
    }

    private void logInfoMessages(Report report) {
        List<String> infoMessages = report.getInfoMessages();
        if (this.infoPosition < infoMessages.size()) {
            this.logger.logEachLine(infoMessages.subList(this.infoPosition, infoMessages.size()));
            this.infoPosition = infoMessages.size();
        }
    }
}

