/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.reporter.util;

import hudson.remoting.VirtualChannel;
import io.jenkins.plugins.reporter.model.Report;
import io.jenkins.plugins.reporter.model.ReportParser;
import io.jenkins.plugins.reporter.util.FileFinder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import jenkins.MasterToSlaveFileCallable;

public class FilesScanner
extends MasterToSlaveFileCallable<Report> {
    private static final long serialVersionUID = 4472630373073191961L;
    private final String filePattern;
    private final ReportParser parser;

    public FilesScanner(String filePattern, ReportParser parser) {
        this.filePattern = filePattern;
        this.parser = parser;
    }

    public Report invoke(File workspace, VirtualChannel channel) throws IOException, InterruptedException {
        Report report = new Report();
        report.logInfo("Searching for all files in '%s' that match the pattern '%s'", workspace.getAbsolutePath(), this.filePattern);
        String[] fileNames = new FileFinder(this.filePattern).find(workspace);
        if (fileNames.length == 0) {
            report.logError("No files found for pattern '%s'. Configuration error?", this.filePattern);
        } else {
            report.logInfo("-> found %s", this.plural(fileNames.length));
            this.scanFiles(workspace, fileNames, report);
        }
        return report;
    }

    private void scanFiles(File workspace, String[] fileNames, Report report) throws IOException {
        for (String fileName : fileNames) {
            Path file = workspace.toPath().resolve(fileName);
            if (!Files.isReadable(file)) {
                report.logError("Skipping file '%s' because Jenkins has no permission to read the file", fileName);
                continue;
            }
            if (this.isEmpty(file)) {
                report.logError("Skipping file '%s' because it's empty", fileName);
                continue;
            }
            this.aggregateReport(file, report);
        }
    }

    private void aggregateReport(Path file, Report aggregatedReport) {
        try {
            Report report = this.parser.parse(file.toFile()).toReport();
            aggregatedReport.logInfo("Successfully parsed file %s", file);
            aggregatedReport.add(report);
        }
        catch (IOException exception) {
            aggregatedReport.logException(exception, "Parsing of file '%s' failed due to an exception:", file);
        }
    }

    private boolean isEmpty(Path file) {
        try {
            return Files.size(file) <= 0L;
        }
        catch (IOException e) {
            return true;
        }
    }

    private String plural(int count) {
        StringBuilder builder = new StringBuilder("file");
        if (count != 1) {
            builder.append('s');
        }
        builder.insert(0, ' ');
        builder.insert(0, count);
        return builder.toString();
    }
}

