/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.reporter.util;

import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import jenkins.MasterToSlaveFileCallable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.selectors.TypeSelector;

public class FileFinder
extends MasterToSlaveFileCallable<String[]> {
    private final String includesPattern;

    public FileFinder(String includesPattern) {
        this.includesPattern = includesPattern;
    }

    public String[] invoke(File workspace, VirtualChannel channel) throws IOException, InterruptedException {
        return this.find(workspace);
    }

    public String[] find(File workspace) {
        try {
            FileSet fileSet = new FileSet();
            Project antProject = new Project();
            fileSet.setProject(antProject);
            fileSet.setDir(workspace);
            fileSet.setIncludes(this.includesPattern);
            TypeSelector selector = new TypeSelector();
            TypeSelector.FileType fileType = new TypeSelector.FileType();
            fileType.setValue("file");
            selector.setType(fileType);
            fileSet.addType(selector);
            return fileSet.getDirectoryScanner(antProject).getIncludedFiles();
        }
        catch (BuildException ignored) {
            return new String[0];
        }
    }
}

