/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.reporter.util;

import hudson.model.Run;
import java.util.Optional;
import java.util.regex.Pattern;

public class BuildResultNavigator {
    private static final String SLASH = "/";

    public Optional<String> getSameUrlForOtherBuild(Run<?, ?> currentBuild, String viewUrl, String resultId, String selectedBuildNumber) {
        try {
            return this.getSameUrlForOtherBuild(currentBuild, viewUrl, resultId, Integer.parseInt(selectedBuildNumber));
        }
        catch (NumberFormatException numberFormatException) {
            return Optional.empty();
        }
    }

    public Optional<String> getSameUrlForOtherBuild(Run<?, ?> currentBuild, String viewUrl, String resultId, int selectedBuildNumber) {
        Run selectedBuild = currentBuild.getParent().getBuildByNumber(selectedBuildNumber);
        if (selectedBuild != null) {
            String match = SLASH + currentBuild.getNumber() + SLASH + resultId;
            String regex = this.escapeMatch(match) + ".*";
            if (viewUrl.contains(match)) {
                String url = viewUrl.replaceFirst(regex, SLASH + selectedBuildNumber + SLASH + resultId);
                return Optional.of(url);
            }
        }
        return Optional.empty();
    }

    public String escapeMatch(String str) {
        Pattern escaper = Pattern.compile("([^a-zA-z0-9])");
        return escaper.matcher(str).replaceAll("\\\\$1");
    }
}

