/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.reporter.steps;

import edu.hm.hafner.util.FilteredLog;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.reporter.Messages;
import io.jenkins.plugins.reporter.ReportAction;
import io.jenkins.plugins.reporter.ReportResult;
import io.jenkins.plugins.reporter.ReportScanner;
import io.jenkins.plugins.reporter.model.DisplayType;
import io.jenkins.plugins.reporter.model.Provider;
import io.jenkins.plugins.reporter.model.Report;
import io.jenkins.plugins.reporter.steps.ReportConfiguration;
import io.jenkins.plugins.reporter.steps.ReportPublisher;
import io.jenkins.plugins.util.JenkinsFacade;
import io.jenkins.plugins.util.LogHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class ReportRecorder
extends Recorder {
    private List<ReportConfiguration> reports = new ArrayList<ReportConfiguration>();
    private String name;
    private Provider provider;
    private String displayType;

    @DataBoundConstructor
    public ReportRecorder() {
    }

    @DataBoundSetter
    public void setReports(List<ReportConfiguration> reports) {
        this.reports = reports;
    }

    public List<ReportConfiguration> getReports() {
        return this.reports;
    }

    protected Object readResolve() {
        if (this.reports == null) {
            this.reports = new ArrayList<ReportConfiguration>();
        }
        if (this.name != null && this.provider != null && this.reports.isEmpty()) {
            ReportConfiguration config = new ReportConfiguration();
            config.setName(this.name);
            config.setProvider(this.provider);
            config.setDisplayType(this.displayType != null ? this.displayType : "dual");
            this.reports.add(config);
        }
        return this;
    }

    @DataBoundSetter
    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @DataBoundSetter
    public void setProvider(Provider provider) {
        this.provider = provider;
    }

    public Provider getProvider() {
        return this.provider;
    }

    public String getDisplayType() {
        return this.displayType;
    }

    @DataBoundSetter
    public void setDisplayType(String displayType) {
        this.displayType = displayType;
    }

    public Descriptor getDescriptor() {
        return (Descriptor)super.getDescriptor();
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        FilePath workspace = build.getWorkspace();
        if (workspace == null) {
            throw new IOException("No workspace found for " + String.valueOf(build));
        }
        this.perform((Run<?, ?>)build, workspace, (TaskListener)listener);
        return true;
    }

    ReportResult perform(Run<?, ?> run, FilePath workspace, TaskListener listener) throws InterruptedException, IOException {
        return this.record(run, workspace, listener);
    }

    private ReportResult record(Run<?, ?> run, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        this.readResolve();
        ReportResult lastResult = null;
        for (ReportConfiguration config : this.reports) {
            if (config.getProvider() == null) continue;
            Report report = this.scan(run, workspace, listener, config.getProvider());
            report.setName(config.getName());
            DisplayType dt = Arrays.stream(DisplayType.values()).filter(e -> e.name().toLowerCase(Locale.ROOT).equals(config.getDisplayType())).findFirst().orElse(DisplayType.ABSOLUTE);
            report.setDisplayType(dt);
            lastResult = this.publishReport(run, listener, config.getProvider().getSymbolName(), report);
        }
        return lastResult;
    }

    ReportResult publishReport(Run<?, ?> run, TaskListener listener, String loggerName, Report report) {
        ReportPublisher publisher = new ReportPublisher(run, report, new LogHandler(listener, loggerName, new FilteredLog("ReportsPublisher")));
        ReportAction action = publisher.attachAction();
        return action.getResult();
    }

    private Report scan(Run<?, ?> run, FilePath workspace, TaskListener listener, Provider provider) throws IOException, InterruptedException {
        ReportScanner reportScanner = new ReportScanner(run, provider, workspace, listener);
        return reportScanner.scan();
    }

    @Extension
    @Symbol(value={"publishReport"})
    public static class Descriptor
    extends BuildStepDescriptor<Publisher> {
        private static final JenkinsFacade JENKINS = new JenkinsFacade();

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        @NonNull
        public String getDisplayName() {
            return Messages.Step_Name();
        }

        @POST
        public FormValidation doCheckName(@QueryParameter(value="name") String name) {
            if (StringUtils.isEmpty((CharSequence)name)) {
                return FormValidation.error((String)"Field 'name' is required.");
            }
            return FormValidation.ok();
        }

        @POST
        public ListBoxModel doFillDisplayTypeItems(@AncestorInPath AbstractProject<?, ?> project) {
            if (JENKINS.hasPermission(Item.CONFIGURE, project)) {
                ListBoxModel r = new ListBoxModel();
                for (DisplayType dt : DisplayType.values()) {
                    r.add(dt.name().toLowerCase());
                }
                return r;
            }
            return new ListBoxModel();
        }
    }
}

