/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.reporter.steps;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.reporter.Messages;
import io.jenkins.plugins.reporter.ReportResult;
import io.jenkins.plugins.reporter.model.DisplayType;
import io.jenkins.plugins.reporter.model.Provider;
import io.jenkins.plugins.reporter.steps.ReportRecorder;
import io.jenkins.plugins.util.JenkinsFacade;
import java.io.Serializable;
import java.util.Set;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class PublishReportStep
extends Step
implements Serializable {
    private static final long serialVersionUID = 423552861898621744L;
    private String name = "";
    private Provider provider;
    private String displayType;

    @DataBoundConstructor
    public PublishReportStep() {
    }

    public String getName() {
        return this.name;
    }

    @DataBoundSetter
    public void setName(String name) {
        this.name = name;
    }

    @DataBoundSetter
    public void setProvider(Provider provider) {
        this.provider = provider;
    }

    public Provider getProvider() {
        return this.provider;
    }

    @DataBoundSetter
    public void setDisplayType(String displayType) {
        this.displayType = displayType;
    }

    public String getDisplayType() {
        return this.displayType;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(context, this);
    }

    static class Execution
    extends SynchronousNonBlockingStepExecution<ReportResult> {
        private static final long serialVersionUID = -6468854519922975080L;
        private final PublishReportStep step;

        protected Execution(@NonNull StepContext context, PublishReportStep step) {
            super(context);
            this.step = step;
        }

        protected ReportResult run() throws Exception {
            ReportRecorder recorder = new ReportRecorder();
            recorder.setName(this.step.getName());
            recorder.setProvider(this.step.getProvider());
            recorder.setDisplayType(this.step.getDisplayType());
            return recorder.perform((Run)this.getContext().get(Run.class), (FilePath)this.getContext().get(FilePath.class), (TaskListener)this.getContext().get(TaskListener.class));
        }
    }

    @Extension
    public static class Descriptor
    extends StepDescriptor {
        private static final JenkinsFacade JENKINS = new JenkinsFacade();

        public Set<Class<?>> getRequiredContext() {
            return Set.of(FlowNode.class, Run.class, TaskListener.class);
        }

        public String getFunctionName() {
            return "publishReport";
        }

        @NonNull
        public String getDisplayName() {
            return Messages.Step_Name();
        }

        public DescriptorExtensionList<Provider, Provider.ProviderDescriptor> getProvider() {
            return Jenkins.get().getDescriptorList(Provider.class);
        }

        @POST
        public FormValidation doCheckName(@QueryParameter(value="name") String name) {
            if (StringUtils.isEmpty((CharSequence)name)) {
                return FormValidation.error((String)"Field 'name' is required.");
            }
            return FormValidation.ok();
        }

        @POST
        public ListBoxModel doFillDisplayTypeItems(@AncestorInPath AbstractProject<?, ?> project) {
            if (JENKINS.hasPermission(Item.CONFIGURE, project)) {
                ListBoxModel r = new ListBoxModel();
                for (DisplayType dt : DisplayType.values()) {
                    r.add(dt.name().toLowerCase());
                }
                return r;
            }
            return new ListBoxModel();
        }
    }
}

