/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.reporter.provider;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.Extension;
import io.jenkins.plugins.reporter.model.Provider;
import io.jenkins.plugins.reporter.model.ReportDto;
import io.jenkins.plugins.reporter.model.ReportParser;
import java.io.File;
import java.io.IOException;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class Json
extends Provider {
    private static final long serialVersionUID = 9141170397250309265L;
    private static final String ID = "json";

    @DataBoundConstructor
    public Json() {
    }

    @Override
    public ReportParser createParser() {
        return new JsonParser();
    }

    public static class JsonParser
    extends ReportParser {
        private static final long serialVersionUID = -5067678137282588916L;

        @Override
        public ReportDto parse(File file) throws IOException {
            return (ReportDto)new ObjectMapper(new JsonFactory()).readerFor(ReportDto.class).readValue(file);
        }
    }

    @Symbol(value={"json"})
    @Extension
    public static class Descriptor
    extends Provider.ProviderDescriptor {
        public Descriptor() {
            super(Json.ID);
        }
    }
}

