/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.reporter.provider;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvParser;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import hudson.Extension;
import io.jenkins.plugins.reporter.Messages;
import io.jenkins.plugins.reporter.model.Item;
import io.jenkins.plugins.reporter.model.Provider;
import io.jenkins.plugins.reporter.model.ReportDto;
import io.jenkins.plugins.reporter.model.ReportParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class Csv
extends Provider {
    private static final long serialVersionUID = 9141170397250309265L;
    private static final String ID = "csv";

    @DataBoundConstructor
    public Csv() {
    }

    @Override
    public ReportParser createParser() {
        if (this.getActualId().equals(this.getDescriptor().getId())) {
            throw new IllegalArgumentException(Messages.Provider_Error());
        }
        return new CsvCustomParser(this.getActualId());
    }

    public static class CsvCustomParser
    extends ReportParser {
        private static final long serialVersionUID = -8689695008930386640L;
        private final String id;
        private List<String> parserMessages;

        public CsvCustomParser(String id) {
            this.id = id;
            this.parserMessages = new ArrayList<String>();
        }

        public String getId() {
            return this.id;
        }

        private char detectDelimiter(File file) throws IOException {
            char[] delimiters = new char[]{',', ';', '\t', '|'};
            int[] delimiterCounts = new int[delimiters.length];
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
                String line;
                int linesToCheck = 5;
                for (int linesChecked = 0; (line = reader.readLine()) != null && linesChecked < linesToCheck; ++linesChecked) {
                    for (int i = 0; i < delimiters.length; ++i) {
                        int n = i;
                        delimiterCounts[n] = delimiterCounts[n] + StringUtils.countMatches((CharSequence)line, (char)delimiters[i]);
                    }
                }
            }
            int maxCount = 0;
            char detectedDelimiter = '\u0000';
            for (int i = 0; i < delimiters.length; ++i) {
                if (delimiterCounts[i] <= maxCount) continue;
                maxCount = delimiterCounts[i];
                detectedDelimiter = delimiters[i];
            }
            return detectedDelimiter;
        }

        @Override
        public ReportDto parse(File file) throws IOException {
            char delimiter = this.detectDelimiter(file);
            CsvMapper mapper = new CsvMapper();
            CsvSchema schema = mapper.schemaFor(String[].class).withColumnSeparator(delimiter);
            mapper.enable(CsvParser.Feature.WRAP_AS_ARRAY);
            mapper.enable(CsvParser.Feature.SKIP_EMPTY_LINES);
            mapper.enable(CsvParser.Feature.ALLOW_TRAILING_COMMA);
            mapper.enable(CsvParser.Feature.INSERT_NULLS_FOR_MISSING_COLUMNS);
            mapper.enable(CsvParser.Feature.TRIM_SPACES);
            MappingIterator it = mapper.readerForListOf(String.class).with((FormatSchema)schema).readValues(file);
            ReportDto report = new ReportDto();
            report.setId(this.getId());
            report.setItems(new ArrayList<Item>());
            List header = (List)it.next();
            List rows = it.readAll();
            int rowCount = 0;
            int headerColumnCount = header.size();
            int colIdxValueStart = 0;
            if (headerColumnCount >= 2) {
                rowCount = rows.size();
            } else {
                this.parserMessages.add(String.format("skipped file - First line has %d elements", headerColumnCount + 1));
            }
            for (int rowIdx = 0; rowIdx < rowCount; ++rowIdx) {
                Object parentId = "report";
                List row = (List)rows.get(rowIdx);
                Item last = null;
                boolean lastItemAdded = false;
                LinkedHashMap<String, Integer> result = new LinkedHashMap<String, Integer>();
                boolean emptyFieldFound = false;
                int rowSize = row.size();
                if (colIdxValueStart == 0) {
                    int colIdx = rowSize - 1;
                    while (colIdx > 1) {
                        String value = (String)row.get(colIdx);
                        if (!NumberUtils.isCreatable((String)value)) {
                            if (colIdxValueStart <= 0) break;
                            this.parserMessages.add(String.format("Found data - fields number = %d  - numeric fields = %d", colIdxValueStart, rowSize - colIdxValueStart));
                            break;
                        }
                        colIdxValueStart = colIdx--;
                    }
                }
                Object valueId = "";
                if (colIdxValueStart > 0 && rowSize >= headerColumnCount) {
                    for (int colIdx = 0; colIdx < headerColumnCount; ++colIdx) {
                        String id = (String)header.get(colIdx);
                        String value = (String)row.get(colIdx);
                        if (colIdx < colIdxValueStart) {
                            if (NumberUtils.isCreatable((String)value) || StringUtils.isBlank((CharSequence)value)) {
                                if (colIdx == 0) {
                                    this.parserMessages.add(String.format("skipped line %d - First column item empty - col = %d ", rowIdx + 2, colIdx + 1));
                                    break;
                                }
                                emptyFieldFound = true;
                                continue;
                            }
                            if (emptyFieldFound) {
                                this.parserMessages.add(String.format("skipped line %d Empty field in col = %d ", rowIdx + 2, colIdx + 1));
                                break;
                            }
                            valueId = (String)valueId + value;
                            Optional<Item> parent = report.findItem((String)parentId, report.getItems());
                            Item item = new Item();
                            lastItemAdded = false;
                            item.setId((String)valueId);
                            item.setName(value);
                            Object finalValueId = valueId;
                            if (parent.isPresent()) {
                                Item p = parent.get();
                                if (!p.hasItems()) {
                                    p.setItems(new ArrayList<Item>());
                                }
                                if (p.getItems().stream().noneMatch(arg_0 -> CsvCustomParser.lambda$parse$0((String)finalValueId, arg_0))) {
                                    p.addItem(item);
                                    lastItemAdded = true;
                                }
                            } else if (report.getItems().stream().noneMatch(arg_0 -> CsvCustomParser.lambda$parse$1((String)finalValueId, arg_0))) {
                                report.getItems().add(item);
                                lastItemAdded = true;
                            }
                            parentId = valueId;
                            last = item;
                            continue;
                        }
                        Number val = 0;
                        if (NumberUtils.isCreatable((String)value)) {
                            val = NumberUtils.createNumber((String)value);
                        }
                        result.put(id, val.intValue());
                    }
                } else {
                    if (colIdxValueStart == 0) {
                        this.parserMessages.add(String.format("skipped line %d - First data row not found", rowIdx + 2));
                        continue;
                    }
                    this.parserMessages.add(String.format("skipped line %d - line has fewer element than title", rowIdx + 2));
                    continue;
                }
                if (lastItemAdded) {
                    last.setResult(result);
                    continue;
                }
                this.parserMessages.add(String.format("ignored line %d - Same fields already exists", rowIdx + 2));
            }
            return report;
        }

        private static /* synthetic */ boolean lambda$parse$1(String finalValueId, Item i) {
            return i.getId().equals(finalValueId);
        }

        private static /* synthetic */ boolean lambda$parse$0(String finalValueId, Item i) {
            return i.getId().equals(finalValueId);
        }
    }

    @Symbol(value={"csv"})
    @Extension
    public static class Descriptor
    extends Provider.ProviderDescriptor {
        public Descriptor() {
            super(Csv.ID);
        }
    }
}

