/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.reporter.model;

import edu.hm.hafner.echarts.Build;
import edu.hm.hafner.echarts.BuildResult;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Run;
import io.jenkins.plugins.reporter.ReportAction;
import io.jenkins.plugins.reporter.ReportResult;
import io.jenkins.plugins.reporter.model.History;
import io.jenkins.plugins.reporter.model.Report;
import io.jenkins.plugins.reporter.model.ResultSelector;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;

public class ReportHistory
implements History {
    private static final int MIN_BUILDS = 2;
    private final Run<?, ?> baseline;
    private final ResultSelector selector;

    public ReportHistory(Run<?, ?> baseline, ResultSelector selector) {
        this.baseline = baseline;
        this.selector = selector;
    }

    @Override
    public Optional<ReportAction> getBaselineAction() {
        return this.selector.get(this.baseline);
    }

    @Override
    public Optional<ReportResult> getBaselineResult() {
        return this.getBaselineAction().map(ReportAction::getResult);
    }

    @Override
    public Optional<ReportResult> getResult() {
        return this.getPreviousAction().map(ReportAction::getResult);
    }

    @Override
    public Optional<Run<?, ?>> getBuild() {
        return this.getPreviousAction().map(ReportAction::getOwner);
    }

    @Override
    public Report getReport() {
        return this.getResult().map(ReportResult::getReport).orElseGet(Report::new);
    }

    @Override
    @NonNull
    public Iterator<BuildResult<ReportResult>> iterator() {
        return new ReportResultIterator(this.baseline, this.selector);
    }

    @Override
    public boolean hasMultipleResults() {
        Iterator<BuildResult<ReportResult>> iterator = this.iterator();
        int count = 1;
        while (iterator.hasNext()) {
            if (count >= 2) {
                return true;
            }
            iterator.next();
            ++count;
        }
        return false;
    }

    private Optional<ReportAction> getPreviousAction() {
        Optional<Run<?, ?>> run = ReportHistory.getRunWithResult(this.baseline, this.selector);
        if (run.isPresent()) {
            return this.selector.get(run.get());
        }
        return Optional.empty();
    }

    private static Optional<Run<?, ?>> getRunWithResult(@CheckForNull Run<?, ?> start, ResultSelector selector) {
        for (Run run = start; run != null; run = run.getPreviousBuild()) {
            Optional<ReportAction> action = selector.get(run);
            if (!action.isPresent()) continue;
            return Optional.of(run);
        }
        return Optional.empty();
    }

    private static class ReportResultIterator
    implements Iterator<BuildResult<ReportResult>> {
        private Optional<Run<?, ?>> cursor;
        private final ResultSelector selector;

        ReportResultIterator(Run<?, ?> baseline, ResultSelector selector) {
            this.cursor = ReportHistory.getRunWithResult(baseline, selector);
            this.selector = selector;
        }

        @Override
        public boolean hasNext() {
            return this.cursor.isPresent();
        }

        @Override
        public BuildResult<ReportResult> next() {
            if (this.cursor.isPresent()) {
                Run<?, ?> run = this.cursor.get();
                Optional<ReportAction> resultAction = this.selector.get(run);
                this.cursor = ReportHistory.getRunWithResult(run.getPreviousBuild(), this.selector);
                if (resultAction.isPresent()) {
                    return new BuildResult(new Build(run.getNumber(), run.getDisplayName(), (int)(run.getTimeInMillis() / 1000L)), (Object)resultAction.get().getResult());
                }
            }
            throw new NoSuchElementException("No more runs with an report: " + String.valueOf(this.cursor));
        }
    }
}

