/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.reporter.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.jenkins.plugins.reporter.model.Item;
import io.jenkins.plugins.reporter.model.Report;
import io.jenkins.plugins.reporter.model.ReportBase;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ReportDto
extends ReportBase {
    @JsonProperty(value="id", required=true)
    private String id;
    @JsonProperty(value="items", required=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<Item> items;
    @JsonProperty(value="colors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Map<String, String> colors;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public void setItems(List<Item> items) {
        this.items = items;
    }

    public Map<String, String> getColors() {
        return this.colors;
    }

    public void setColors(Map<String, String> colors) {
        this.colors = colors;
    }

    @JsonIgnore
    public Report toReport() {
        Report report = new Report();
        report.setId(this.getId());
        report.setItems(Optional.ofNullable(this.getItems()).orElseGet(Collections::emptyList));
        report.setColors(Optional.ofNullable(this.getColors()).orElseGet(Collections::emptyMap));
        return report;
    }
}

