/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.reporter.model;

import com.google.errorprone.annotations.FormatMethod;
import io.jenkins.plugins.reporter.model.DisplayType;
import io.jenkins.plugins.reporter.model.Item;
import io.jenkins.plugins.reporter.model.Palette;
import io.jenkins.plugins.reporter.model.ReportBase;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class Report
extends ReportBase
implements Serializable {
    private static final long serialVersionUID = 302445084497230108L;
    private static final String DEFAULT_COLOR = "#9E9E9E";
    private final List<String> infoMessages;
    private final List<String> errorMessages;
    private DisplayType displayType = DisplayType.ABSOLUTE;
    private List<Report> subReports;
    private String id;
    private String name;
    private List<Item> items;
    private Map<String, String> colors;

    public Report() {
        this("-");
    }

    public Report(String name) {
        this.infoMessages = new ArrayList<String>();
        this.errorMessages = new ArrayList<String>();
        this.subReports = new ArrayList<Report>();
        this.colors = new HashMap<String, String>();
        this.items = new ArrayList<Item>();
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Report> getSubReports() {
        return this.subReports;
    }

    public void setSubReports(List<Report> subReports) {
        this.subReports = subReports;
    }

    public DisplayType getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(DisplayType displayType) {
        this.displayType = displayType;
    }

    public List<Item> getItems() {
        if (this.items == null) {
            return Collections.emptyList();
        }
        return this.items;
    }

    public void setItems(List<Item> items) {
        this.items = items;
    }

    public Map<String, String> getColors() {
        if (this.colors == null) {
            return Collections.emptyMap();
        }
        return this.colors;
    }

    public void setColors(Map<String, String> colors) {
        this.colors = colors;
    }

    public void add(Report report) {
        if (StringUtils.isEmpty((CharSequence)this.id)) {
            this.setId(report.getId());
            this.logInfo("First added report. Set ID='%s'", report.getId());
        }
        if (this.getId().equals(report.getId())) {
            this.logInfo("Add report with ID='%s'.", report.getId());
            this.subReports.add(report);
            this.infoMessages.addAll(report.getInfoMessages());
            this.errorMessages.addAll(report.getErrorMessages());
            this.addColors(report.getColors());
            this.addItems(report.getItems());
            this.logInfo("Successfully added report with ID='%s'", report.getId());
        } else {
            this.logInfo("Skip adding report with ID='%s' because it does not match parent ID='%s'.", report.getId(), this.getId());
        }
    }

    public List<String> getInfoMessages() {
        return this.infoMessages;
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public String getColor(String id) {
        String color = this.getColors().getOrDefault(id, DEFAULT_COLOR);
        if (!color.startsWith("#")) {
            try {
                return Palette.valueOf(color).getColor();
            }
            catch (IllegalArgumentException e) {
                return DEFAULT_COLOR;
            }
        }
        return color;
    }

    public boolean hasColors() {
        return this.colors != null && this.colors.size() > 0;
    }

    public boolean hasItems() {
        return this.items != null && this.items.size() > 0;
    }

    public LinkedHashMap<String, Integer> aggregate(List<Item> items) {
        return items.stream().map(Item::getResult).flatMap(map -> map.entrySet().stream()).collect(Collectors.groupingBy(Map.Entry::getKey, LinkedHashMap::new, Collectors.summingInt(Map.Entry::getValue)));
    }

    public Optional<Item> findItem(String id) {
        return this.findItem(id, this.items);
    }

    public List<String> getColorIds() {
        if (this.aggregate().size() == 1) {
            return this.flattItems(this.getItems()).stream().map(Item::getId).collect(Collectors.toList());
        }
        return new ArrayList<String>(this.aggregate().keySet());
    }

    public LinkedHashMap<String, Integer> aggregate() {
        return this.aggregate(this.getItems());
    }

    @FormatMethod
    public void logInfo(String format, Object ... args) {
        this.infoMessages.add(String.format(format, args));
    }

    @FormatMethod
    public void logError(String format, Object ... args) {
        this.errorMessages.add(String.format(format, args));
    }

    @FormatMethod
    public void logException(Exception exception, String format, Object ... args) {
        this.logError(format, args);
        Collections.addAll(this.errorMessages, ExceptionUtils.getRootCauseStackTrace((Throwable)exception));
    }

    private void addColors(Map<String, String> colors) {
        this.setColors(Stream.concat(this.getColors().entrySet().stream(), colors.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    private void addItems(List<Item> itemsToAdd) {
        for (Item item : itemsToAdd) {
            Optional<Item> parent = this.items.stream().filter(i -> i.getId().equals(item.getId())).findAny();
            if (parent.isPresent()) {
                if (!item.hasItems()) continue;
                this.merge(item, item.getItems());
                continue;
            }
            this.logInfo("Add item wih ID='%s' to items.", item.getId());
            this.items.add(item);
        }
    }

    private void merge(Item parentItem, List<Item> itemsToMerge) {
        for (Item item : itemsToMerge) {
            if (item.hasItems()) {
                this.merge(item, item.getItems());
                continue;
            }
            Optional<Item> found = this.findItem(parentItem.getId(), this.items);
            if (found.isPresent()) {
                this.logInfo("Add item with ID='%s' to parent item with ID='%s'.", item.getId(), found.get().getId());
                Item parent = found.get();
                parent.addItem(item);
                continue;
            }
            this.logError("No parent item found for ID='%s' in items.", parentItem.getId());
        }
    }
}

