/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.reporter.model;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.FilePath;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.util.FormValidation;
import io.jenkins.plugins.reporter.Messages;
import io.jenkins.plugins.reporter.model.Report;
import io.jenkins.plugins.reporter.model.ReportParser;
import io.jenkins.plugins.reporter.util.FilesScanner;
import io.jenkins.plugins.reporter.util.LogHandler;
import io.jenkins.plugins.util.JenkinsFacade;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public abstract class Provider
extends AbstractDescribableImpl<Provider>
implements Serializable {
    private static final long serialVersionUID = -1356603376948787474L;
    private String pattern = "";
    private String id = "";
    private JenkinsFacade jenkins = new JenkinsFacade();

    protected Object readResolve() {
        this.jenkins = new JenkinsFacade();
        return this;
    }

    @DataBoundSetter
    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getActualId() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.getId(), (CharSequence)this.getDescriptor().getId());
    }

    @DataBoundSetter
    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @CheckForNull
    public String getPattern() {
        return this.pattern;
    }

    public String getSymbolName() {
        return this.getDescriptor().getSymbolName();
    }

    public abstract ReportParser createParser();

    public ProviderDescriptor getDescriptor() {
        return (ProviderDescriptor)this.jenkins.getDescriptorOrDie(this.getClass());
    }

    public Report scan(Run<?, ?> run, FilePath workspace, LogHandler logger) {
        return this.scanInWorkspace(workspace, this.getPattern(), logger);
    }

    private Report scanInWorkspace(FilePath workspace, String pattern, LogHandler logger) {
        try {
            Report report = (Report)workspace.act((FilePath.FileCallable)new FilesScanner(this.getPattern(), this.createParser()));
            logger.log(report);
            return report;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static abstract class ProviderDescriptor
    extends Descriptor<Provider> {
        private final String defaultId;

        protected ProviderDescriptor(String defaultId) {
            this.defaultId = defaultId;
        }

        public String getId() {
            return this.defaultId;
        }

        public String getName() {
            return this.getDisplayName();
        }

        public String getSymbolName() {
            String[] symbols;
            Symbol annotation = ((Object)((Object)this)).getClass().getAnnotation(Symbol.class);
            if (annotation != null && (symbols = annotation.value()).length > 0) {
                return symbols[0];
            }
            return "undefined";
        }

        @POST
        public FormValidation doCheckPattern(@QueryParameter(value="pattern") String pattern) {
            if (StringUtils.isEmpty((CharSequence)pattern)) {
                return FormValidation.error((String)"Field 'pattern' is required.");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckId(@QueryParameter(value="id") String id) {
            if (this.getSymbolName().equals("csv") && StringUtils.isEmpty((CharSequence)id)) {
                return FormValidation.error((String)Messages.Provider_Error());
            }
            return FormValidation.ok();
        }
    }
}

