/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.reporter.model;

import io.jenkins.plugins.datatables.TableColumn;
import io.jenkins.plugins.reporter.model.Item;
import io.jenkins.plugins.reporter.model.Report;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.text.CaseUtils;

public class ItemTableModel {
    private final Report report;
    private final Item item;

    public ItemTableModel(Report report, Item item) {
        this.report = report;
        this.item = item;
    }

    public String getId() {
        return this.item.getId();
    }

    public Report getReport() {
        return this.report;
    }

    public Item getItem() {
        return this.item;
    }

    public List<TableColumn> getColumns() {
        ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
        this.item.getResult().keySet().forEach(property -> columns.add(this.createResultAbsoluteColumn((String)property)));
        return columns;
    }

    public List<ItemRow> getRows() {
        return this.item.getItems().stream().map(item -> new ItemRow(this.report, (Item)item, this)).collect(Collectors.toList());
    }

    protected TableColumn createResultAbsoluteColumn(String property) {
        return new TableColumn.ColumnBuilder().withDataPropertyKey(String.format("%s-absolute", property)).withHeaderLabel(CaseUtils.toCamelCase((String)property, (boolean)true, (char[])new char[0])).withHeaderClass(TableColumn.ColumnCss.NUMBER).build();
    }

    public String label(Integer value) {
        return this.item.getLabel(this.report, value, (double)value.intValue() / (double)this.item.getTotal() * 100.0);
    }

    public static class ItemRow {
        private final Report report;
        private final Item item;
        private final ItemTableModel model;

        ItemRow(Report report, Item item, ItemTableModel model) {
            this.report = report;
            this.item = item;
            this.model = model;
        }

        public String getId() {
            return this.item.getEncodedId();
        }

        public String getName() {
            return this.item.getName();
        }

        public Item getItem() {
            return this.item;
        }

        public double getPercentage(String id) {
            int val = this.item.getResult().getOrDefault(id, -1);
            if (val == -1) {
                val = this.item.getTotal();
                return (double)val / (double)this.model.getItem().getTotal() * 100.0;
            }
            return (double)val / (double)this.item.getTotal() * 100.0;
        }

        public boolean containsColorItem(String id) {
            int val = this.item.getResult().getOrDefault(id, -1);
            if (val == -1) {
                return Objects.equals(this.item.getId(), id);
            }
            return true;
        }

        public Map<String, String> getColors() {
            return this.report.getColors();
        }

        public String getColor(String id) {
            return this.report.getColor(id);
        }

        public String label(String id, Integer value) {
            if (this.item.getResult().size() == 1) {
                return this.item.getLabel(this.report, value, (double)value.intValue() / (double)this.model.getItem().getTotal() * 100.0);
            }
            return this.item.getLabel(this.report, value, (double)value.intValue() / (double)this.model.getItem().getResult().get(id).intValue() * 100.0);
        }

        public String tooltip(String id, double percentage) {
            return String.format("%s: %.2f%%", id, percentage);
        }
    }
}

