/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.reporter.model;

import edu.hm.hafner.echarts.SeriesBuilder;
import io.jenkins.plugins.reporter.ReportResult;
import io.jenkins.plugins.reporter.model.Item;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ItemSeriesBuilder
extends SeriesBuilder<ReportResult> {
    private final Item item;

    public ItemSeriesBuilder(Item item) {
        this.item = item;
    }

    protected Map<String, Integer> computeSeries(ReportResult reportResult) {
        List<Item> items;
        if (this.item.getId().equals("report")) {
            if (this.item.getResult().size() == 1) {
                return reportResult.getReport().getItems().stream().collect(Collectors.toMap(Item::getId, Item::getTotal));
            }
            return reportResult.getReport().aggregate();
        }
        Item parent = reportResult.getReport().findItem(this.item.getId()).orElse(new Item());
        List<Item> list = items = parent.hasItems() ? parent.getItems() : Collections.singletonList(parent);
        if (this.item.getResult().size() == 1) {
            return items.stream().collect(Collectors.toMap(Item::getId, Item::getTotal));
        }
        return reportResult.getReport().aggregate(items);
    }
}

