/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.reporter.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.jenkins.plugins.reporter.model.DisplayType;
import io.jenkins.plugins.reporter.model.Report;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import jline.internal.Nullable;

public class Item
implements Serializable {
    private static final long serialVersionUID = -2800979294230808946L;
    @JsonProperty(value="id", required=true)
    private String id;
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="result", required=false)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    LinkedHashMap<String, Integer> result;
    @JsonProperty(value="items", required=false)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    List<Item> items;

    public String getId() {
        return this.id;
    }

    @JsonIgnore
    public String getEncodedId() {
        try {
            return URLEncoder.encode(this.getId(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonIgnore
    public LinkedHashMap<String, Integer> getResult() {
        if (this.result != null) {
            return this.result;
        }
        return this.getItems().stream().map(Item::getResult).flatMap(map -> map.entrySet().stream()).collect(Collectors.groupingBy(Map.Entry::getKey, LinkedHashMap::new, Collectors.summingInt(Map.Entry::getValue)));
    }

    @JsonIgnore
    public int getTotal() {
        return this.getResult().values().stream().reduce(0, Integer::sum);
    }

    @JsonIgnore
    public String getLabel(Report report, Integer value, double percentage) {
        if (report.getDisplayType().equals((Object)DisplayType.DUAL)) {
            return String.format("%s (%.2f%%)", value.toString(), percentage);
        }
        if (report.getDisplayType().equals((Object)DisplayType.RELATIVE)) {
            return String.format("%.2f%%", percentage);
        }
        return value.toString();
    }

    public void setResult(LinkedHashMap<String, Integer> result) {
        this.result = result;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public boolean hasItems() {
        return !Objects.isNull(this.items) && !this.items.isEmpty();
    }

    public void setItems(List<Item> items) {
        this.items = items;
    }

    public void addItem(Item item) {
        this.items.add(item);
    }
}

