/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.reporter.charts;

import edu.hm.hafner.echarts.BuildResult;
import edu.hm.hafner.echarts.ChartModelConfiguration;
import edu.hm.hafner.echarts.LineSeries;
import edu.hm.hafner.echarts.LinesChartModel;
import edu.hm.hafner.echarts.LinesDataSet;
import edu.hm.hafner.echarts.SeriesBuilder;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jenkins.plugins.reporter.ReportResult;
import io.jenkins.plugins.reporter.model.Item;
import io.jenkins.plugins.reporter.model.Report;
import java.util.List;
import java.util.Optional;

public class ItemHistoryChart {
    public LinesChartModel create(Iterable<? extends BuildResult<ReportResult>> results, ChartModelConfiguration configuration, SeriesBuilder<ReportResult> builder, Report report, @Nullable List<Item> items) {
        LinesDataSet dataSet = builder.createDataSet(configuration, results);
        LinesChartModel model = new LinesChartModel(dataSet);
        if (!dataSet.isEmpty()) {
            model.useContinuousRangeAxis();
            model.setRangeMin(0);
            dataSet.getDataSetIds().forEach(id -> {
                Optional item;
                Optional<Object> optional = item = items != null ? items.stream().filter(i -> i.getId().equals(id)).findFirst() : Optional.empty();
                if (item.isPresent()) {
                    Item i2 = (Item)item.get();
                    LineSeries series = new LineSeries(i2.getName(), report.getColor(i2.getId()), LineSeries.StackedMode.STACKED, LineSeries.FilledMode.FILLED);
                    series.addAll(dataSet.getSeries(i2.getId()));
                    model.addSeries(new LineSeries[]{series});
                } else {
                    LineSeries series = new LineSeries(id, report.getColor((String)id), LineSeries.StackedMode.STACKED, LineSeries.FilledMode.FILLED);
                    series.addAll(dataSet.getSeries(id));
                    model.addSeries(new LineSeries[]{series});
                }
            });
        }
        return model;
    }
}

