/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.reporter;

import hudson.model.Run;
import io.jenkins.plugins.reporter.model.Report;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ReportResult
implements Serializable {
    private static final long serialVersionUID = 7761451736733548294L;
    private transient Run<?, ?> owner;
    private final Report report;
    private final List<String> errors;
    private final List<String> messages;

    public ReportResult(Run<?, ?> owner, Report report) {
        this.owner = owner;
        this.report = report;
        this.messages = new ArrayList<String>(report.getInfoMessages());
        this.errors = new ArrayList<String>(report.getErrorMessages());
    }

    public Run<?, ?> getOwner() {
        return this.owner;
    }

    public void setOwner(Run<?, ?> owner) {
        this.owner = owner;
    }

    public Report getReport() {
        return this.report;
    }

    public List<String> getErrorMessages() {
        return Collections.unmodifiableList(this.errors);
    }

    public List<String> getInfoMessages() {
        return Collections.unmodifiableList(this.messages);
    }
}

