/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.reporter;

import edu.hm.hafner.echarts.BuildResult;
import edu.hm.hafner.echarts.ChartModelConfiguration;
import edu.hm.hafner.echarts.JacksonFacade;
import hudson.model.ModelObject;
import hudson.model.Run;
import io.jenkins.plugins.reporter.Messages;
import io.jenkins.plugins.reporter.ReportResult;
import io.jenkins.plugins.reporter.charts.ItemHistoryChart;
import io.jenkins.plugins.reporter.charts.ItemPieChart;
import io.jenkins.plugins.reporter.model.ByIdResultSelector;
import io.jenkins.plugins.reporter.model.Item;
import io.jenkins.plugins.reporter.model.ItemSeriesBuilder;
import io.jenkins.plugins.reporter.model.ItemTableModel;
import io.jenkins.plugins.reporter.model.ReportHistory;
import io.jenkins.plugins.reporter.util.BuildResultNavigator;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class ReportDetails
implements ModelObject {
    private final transient Run<?, ?> owner;
    private final String displayName;
    private final ReportResult result;
    private final Item item;
    private final Optional<ReportDetails> parentViewModel;
    private final String url;
    private final List<String> errorMessages = new ArrayList<String>();
    private final List<String> infoMessages = new ArrayList<String>();

    public ReportDetails(Run<?, ?> owner, String url, ReportResult result, String displayName, Item item, Optional<ReportDetails> parentViewModel) {
        this.parentViewModel = parentViewModel;
        this.owner = owner;
        this.url = url;
        this.result = result;
        this.item = item;
        this.displayName = displayName;
        this.infoMessages.addAll(result.getInfoMessages());
        this.errorMessages.addAll(result.getErrorMessages());
    }

    ReportResult getResult() {
        return this.result;
    }

    public Collection<String> getErrorMessages() {
        return this.errorMessages;
    }

    public Collection<String> getInfoMessages() {
        return this.infoMessages;
    }

    public Item getItem() {
        return this.item;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public final Run<?, ?> getOwner() {
        return this.owner;
    }

    public String getUrl() {
        return this.url;
    }

    public Optional<ReportDetails> getPrevious() {
        return this.parentViewModel;
    }

    public String getItemPieChartModel() {
        return new JacksonFacade().toJson((Object)new ItemPieChart().create(this.result.getReport(), this.getItem()));
    }

    public ItemTableModel getTableModel() {
        return new ItemTableModel(this.result.getReport(), this.getItem());
    }

    @JavaScriptMethod
    public String getBuildTrend(String configuration) {
        return new JacksonFacade().toJson((Object)new ItemHistoryChart().create(this.createHistory(), ChartModelConfiguration.fromJson((String)configuration), new ItemSeriesBuilder(this.item), this.result.getReport(), this.item.getItems()));
    }

    @JavaScriptMethod
    public String getUrlForBuild(String build, String detailsUrl) {
        ReportHistory history = this.createHistory();
        for (BuildResult<ReportResult> buildResult : history) {
            if (!buildResult.getBuild().getDisplayName().equals(build)) continue;
            return new BuildResultNavigator().getSameUrlForOtherBuild(this.owner, detailsUrl, this.getUrl(), buildResult.getBuild().getNumber()).orElse("");
        }
        return "";
    }

    private ReportHistory createHistory() {
        return new ReportHistory(this.owner, new ByIdResultSelector(this.result.getReport().getId()));
    }

    public Object getDynamic(String link, StaplerRequest2 request, StaplerResponse2 response) {
        try {
            String decodedLink = URLDecoder.decode(link, "UTF-8");
            Item subItem = this.item.getItems().stream().filter(i -> Objects.equals(i.getId(), decodedLink)).findFirst().orElseThrow(NoSuchElementException::new);
            String url = this.getUrl() + "/" + link;
            return new ReportDetails(this.owner, URLEncoder.encode(url, "UTF-8"), this.result, Messages.Module_Description(subItem.getName()), subItem, Optional.of(this));
        }
        catch (UnsupportedEncodingException | NoSuchElementException ignored) {
            try {
                response.sendRedirect2("../");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this;
        }
    }
}

