/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.reporter;

import hudson.model.Action;
import hudson.model.Run;
import io.jenkins.plugins.reporter.JobAction;
import io.jenkins.plugins.reporter.ReportDetails;
import io.jenkins.plugins.reporter.ReportResult;
import io.jenkins.plugins.reporter.model.Item;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import jenkins.model.RunAction2;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.kohsuke.stapler.StaplerProxy;

public class ReportAction
implements SimpleBuildStep.LastBuildAction,
RunAction2,
StaplerProxy,
Serializable {
    private static final long serialVersionUID = 7179008520286494522L;
    public static final String REPORT_ID = "report";
    private transient Run<?, ?> owner;
    private final String id;
    private final String name;
    private final ReportResult result;

    public ReportAction(Run<?, ?> owner, ReportResult result, String name) {
        this.owner = owner;
        this.result = result;
        this.id = result.getReport().getId();
        this.name = name;
    }

    public void onAttached(Run<?, ?> r) {
        this.owner = r;
        this.result.setOwner(r);
    }

    public void onLoad(Run<?, ?> r) {
        this.onAttached(r);
    }

    protected Object readResolve() {
        return this;
    }

    public Run<?, ?> getOwner() {
        return this.owner;
    }

    @Whitelisted
    public String getId() {
        return this.id;
    }

    public String getIconFileName() {
        return "/plugin/nested-data-reporting/icons/data-reporting-icon.svg";
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getUrlName() {
        try {
            return "report-" + URLEncoder.encode(this.getName(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public ReportDetails getTarget() {
        Item item = new Item();
        item.setId(REPORT_ID);
        item.setName(this.name);
        item.setItems(this.result.getReport().getItems());
        return new ReportDetails(this.getOwner(), this.getUrlName(), this.result, this.name, item, Optional.empty());
    }

    @Whitelisted
    public ReportResult getResult() {
        return this.result;
    }

    public String getName() {
        return this.name;
    }

    public Collection<? extends Action> getProjectActions() {
        return Collections.singletonList(new JobAction(this.getOwner().getParent(), this.name, this.result.getReport()));
    }
}

