/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.reporter;

import edu.hm.hafner.echarts.BuildResult;
import edu.hm.hafner.echarts.ChartModelConfiguration;
import edu.hm.hafner.echarts.JacksonFacade;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import io.jenkins.plugins.echarts.AsyncConfigurableTrendChart;
import io.jenkins.plugins.reporter.ReportResult;
import io.jenkins.plugins.reporter.charts.ItemHistoryChart;
import io.jenkins.plugins.reporter.model.ByIdResultSelector;
import io.jenkins.plugins.reporter.model.History;
import io.jenkins.plugins.reporter.model.NullReportHistory;
import io.jenkins.plugins.reporter.model.Report;
import io.jenkins.plugins.reporter.model.ReportHistory;
import io.jenkins.plugins.reporter.model.ReportSeriesBuilder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class JobAction
implements AsyncConfigurableTrendChart,
Action {
    private final Job<?, ?> owner;
    private final String name;
    private final Report report;
    private static final JacksonFacade JACKSON_FACADE = new JacksonFacade();
    public static final String ICON = "/plugin/nested-data-reporting/icons/data-reporting-icon.svg";

    public JobAction(Job<?, ?> owner, String name, Report report) {
        this.owner = owner;
        this.name = name;
        this.report = report;
    }

    public String getIconFileName() {
        return ICON;
    }

    public String getDisplayName() {
        return this.name;
    }

    public String getUrlName() {
        try {
            History history = this.createBuildHistory();
            Iterator<BuildResult<ReportResult>> iterator = history.iterator();
            if (iterator.hasNext()) {
                BuildResult<ReportResult> buildResult = iterator.next();
                return buildResult.getBuild().getNumber() + "/report-" + URLEncoder.encode(this.name, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            return String.valueOf(this.getOwner().getLastBuild().getNumber());
        }
        return String.valueOf(this.getOwner().getLastBuild().getNumber());
    }

    public History createBuildHistory() {
        Run lastCompletedBuild = this.owner.getLastCompletedBuild();
        if (lastCompletedBuild == null) {
            return new NullReportHistory();
        }
        return new ReportHistory(lastCompletedBuild, new ByIdResultSelector(this.report.getId()));
    }

    public Report getReport() {
        return this.report;
    }

    @JavaScriptMethod
    public String getTrendId() {
        return this.report.getId();
    }

    public Job<?, ?> getOwner() {
        return this.owner;
    }

    @JavaScriptMethod
    public String getConfigurableBuildTrendModel(String configuration) {
        ChartModelConfiguration modelConfiguration = ChartModelConfiguration.fromJson((String)configuration);
        return new JacksonFacade().toJson((Object)new ItemHistoryChart().create(this.createBuildHistory(), modelConfiguration, new ReportSeriesBuilder(), this.report, this.report.getItems()));
    }

    public boolean isTrendVisible() {
        return this.createBuildHistory().hasMultipleResults();
    }
}

