// CHECKSTYLE:OFF

package io.jenkins.plugins.reporter;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code Module.Description}: {@code {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0}}
     */
    public static String Module_Description(Object arg0) {
        return holder.format("Module.Description", arg0);
    }

    /**
     * Key {@code Module.Description}: {@code {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0}}
     */
    public static Localizable _Module_Description(Object arg0) {
        return new Localizable(holder, "Module.Description", arg0);
    }

    /**
     * Key {@code Step.Name}: {@code Publish report files like json, yaml,
     * csv or xml}.
     * 
     * @return
     *     {@code Publish report files like json, yaml, csv or xml}
     */
    public static String Step_Name() {
        return holder.format("Step.Name");
    }

    /**
     * Key {@code Step.Name}: {@code Publish report files like json, yaml,
     * csv or xml}.
     * 
     * @return
     *     {@code Publish report files like json, yaml, csv or xml}
     */
    public static Localizable _Step_Name() {
        return new Localizable(holder, "Step.Name");
    }

    /**
     * Key {@code PublishReports.DisplayName}: {@code Publish reports}.
     * 
     * @return
     *     {@code Publish reports}
     */
    public static String PublishReports_DisplayName() {
        return holder.format("PublishReports.DisplayName");
    }

    /**
     * Key {@code PublishReports.DisplayName}: {@code Publish reports}.
     * 
     * @return
     *     {@code Publish reports}
     */
    public static Localizable _PublishReports_DisplayName() {
        return new Localizable(holder, "PublishReports.DisplayName");
    }

    /**
     * Key {@code Provider.Error}: {@code A csv provider needs an 'id',
     * because unlike structured files like json, yaml or xml, the id cannot
     * be determined via the file. Please use a unique id for your report.}.
     * 
     * @return
     *     {@code A csv provider needs an 'id', because unlike structured files
     *     like json, yaml or xml, the id cannot be determined via the file.
     *     Please use a unique id for your report.}
     */
    public static String Provider_Error() {
        return holder.format("Provider.Error");
    }

    /**
     * Key {@code Provider.Error}: {@code A csv provider needs an 'id',
     * because unlike structured files like json, yaml or xml, the id cannot
     * be determined via the file. Please use a unique id for your report.}.
     * 
     * @return
     *     {@code A csv provider needs an 'id', because unlike structured files
     *     like json, yaml or xml, the id cannot be determined via the file.
     *     Please use a unique id for your report.}
     */
    public static Localizable _Provider_Error() {
        return new Localizable(holder, "Provider.Error");
    }

}
