/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.miscjenkinsinfotools.pipeline.related.checker;

import hudson.AbortException;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;

public class SanityStep
extends SynchronousStepExecution<Void>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private StepContext context;
    private boolean isBuilding;
    private boolean inQueue;
    private boolean isSuccess;
    private boolean jobExists;
    private boolean hasRun;
    private ArrayList<String> deps;

    protected SanityStep(StepContext context, boolean isBuilding, ArrayList<String> deps, boolean inQueue, boolean isSuccess, boolean jobExists, boolean hasRun) {
        super(context);
        this.isBuilding = isBuilding;
        this.context = context;
        this.deps = deps;
        this.inQueue = inQueue;
        this.isSuccess = isSuccess;
        this.jobExists = jobExists;
        this.hasRun = hasRun;
    }

    protected Void run() throws Exception {
        Jenkins server = Jenkins.getInstanceOrNull();
        if (server == null) {
            return null;
        }
        PrintStream logger = ((TaskListener)this.getContext().get(TaskListener.class)).getLogger();
        for (String jobName : this.deps) {
            logger.println("Testing Job: " + jobName);
            Job job = (Job)server.getItemByFullName(jobName, Job.class);
            if (this.jobExists && job == null) {
                this.context.setResult(Result.FAILURE);
                throw new AbortException("Job: " + jobName + ", does not exist!");
            }
            if (this.isBuilding && job.isBuilding()) {
                this.context.setResult(Result.ABORTED);
                throw new InterruptedException("Job: " + jobName + ". is currently building!");
            }
            if (this.inQueue && job.isInQueue()) {
                this.context.setResult(Result.ABORTED);
                throw new InterruptedException("Job: " + jobName + ", is currently in queue!");
            }
            Run last = job.getLastCompletedBuild();
            if (this.hasRun && null == last) {
                this.context.setResult(Result.ABORTED);
                throw new InterruptedException("Job: " + jobName + ", has never run!");
            }
            if (!this.isSuccess || Result.SUCCESS == last.getResult()) continue;
            this.context.setResult(Result.ABORTED);
            throw new InterruptedException("Job: " + jobName + ", is not in state SUCCESS!");
        }
        logger.println("All requested jobs look good!");
        return null;
    }
}

