/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.miscjenkinsinfotools.pipeline.netInfo;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Set;
import jenkins.security.Roles;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.jenkinsci.remoting.RoleChecker;
import org.jenkinsci.remoting.RoleSensitive;
import org.kohsuke.stapler.DataBoundConstructor;

public class GetCurrentBuildHost
extends Step
implements Serializable {
    private static final long serialVersionUID = 1505586566993544821L;

    @DataBoundConstructor
    public GetCurrentBuildHost() {
    }

    public StepExecution start(StepContext context) throws Exception {
        return new StepExecutionImpl(this, context);
    }

    private static class StepExecutionImpl
    extends SynchronousNonBlockingStepExecution<String> {
        private static final long serialVersionUID = 1505586566993544821L;

        StepExecutionImpl(GetCurrentBuildHost step, StepContext context) {
            super(context);
        }

        protected String run() throws Exception {
            FilePath workspace = (FilePath)this.getContext().get(FilePath.class);
            TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
            if (workspace == null) {
                return InetAddress.getLocalHost().getHostName();
            }
            if (listener == null) {
                return InetAddress.getLocalHost().getHostName();
            }
            return (String)workspace.act((Callable)new AgentCallable(listener));
        }
    }

    private static class AgentCallable
    implements Callable<String, IOException>,
    Serializable {
        private static final long serialVersionUID = 1L;

        AgentCallable(TaskListener listener) {
        }

        public String call() throws IOException {
            return InetAddress.getLocalHost().getHostName();
        }

        public void checkRoles(RoleChecker checker) throws SecurityException {
            checker.check((RoleSensitive)this, Roles.SLAVE);
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "getCurrentBuildHost";
        }

        public String getDisplayName() {
            return "Get the Build Hostname in context";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.emptySet();
        }
    }
}

