/*
 * Decompiled with CFR 0.152.
 */
package org.miniorange.saml;

import hudson.model.User;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.HttpResponse;
import org.miniorange.saml.MoSAMLException;
import org.miniorange.saml.MoSAMLManager;
import org.miniorange.saml.MoSAMLPluginSettings;
import org.miniorange.saml.MoSAMLResponse;
import org.miniorange.saml.crowdIntegration.MoSAMLCrowdGroupManagement;

public class MoSAMLTemplateManager {
    private MoSAMLPluginSettings settings;
    private static final Logger LOGGER = Logger.getLogger(MoSAMLManager.class.getName());

    public MoSAMLTemplateManager(MoSAMLPluginSettings settings) {
        this.settings = settings;
    }

    public HttpResponse showTestConfigurationResult(MoSAMLResponse samlResponse, HttpServletRequest request, HttpServletResponse response) throws IOException, MoSAMLException {
        LOGGER.info("Test Configuration called.");
        String username = "";
        StringBuffer htmlStart = new StringBuffer("<div style=\"font-family:Calibri;padding:0 3%;\">");
        String[] usernameArray = samlResponse.getAttributes().get(this.settings.getUsernameAttribute());
        if (usernameArray != null && usernameArray.length == 1) {
            username = usernameArray[0];
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            LOGGER.fine("username is blank");
            htmlStart = htmlStart.append("<div style=\"color: #a94442;background-color: #f2dede;padding: 15px;margin-bottom: 20px;text-align:center;border:1px solid #E6B3B2;font-size:18pt;\">TEST FAILED</div><div style=\"color: #a94442;font-size:14pt; margin-bottom:20px;\">WARNING: Username attribute not found in the response. Users will not be able to login. [Please check Username attribute in User profile tab it should be similar to attribute value in IDP.]</div>");
        } else {
            LOGGER.fine("username is not blank " + username);
            htmlStart = htmlStart.append("<div style=\"color: #3c763d;background-color: #dff0d8; padding:2%;margin-bottom:20px;text-align:center; border:1px solid #AEDB9A; font-size:18pt;\">TEST SUCCESSFUL</div>");
        }
        htmlStart = htmlStart.append("<span style=\"font-size:14pt;\"><b>Hello</b>, " + username + "</span><br/><p style=\"font-weight:bold;font-size:14pt;margin-left:1%;\">ATTRIBUTES RECEIVED:</p><table style=\"border-collapse:collapse;border-spacing:0; display:table;width:100%; font-size:14pt;background-color:#EDEDED;\"><tr style=\"text-align:center;\"><td style=\"font-weight:bold;border:2px solid #949090;padding:2%;\">ATTRIBUTE NAME</td><td style=\"font-weight:bold;padding:2%;border:2px solid #949090; word-wrap:break-word;\">ATTRIBUTE VALUE</td></tr>");
        for (String key : samlResponse.getAttributes().keySet()) {
            htmlStart = htmlStart.append("<tr><td style=\"font-weight:bold;border:2px solid #949090;padding:2%;\">" + key + "</td><td style=\"padding:2%;border:2px solid #949090;word-wrap:break-word;\">");
            Object[] values = samlResponse.getAttributes().get(key);
            htmlStart = htmlStart.append(StringUtils.join((Object[])values, (String)"<hr/>"));
            htmlStart = htmlStart.append("</td></tr>");
        }
        if (!(this.settings.getCrowdURL().isEmpty() && this.settings.getCrowdApplicationName().isEmpty() && this.settings.getCrowdApplicationPassword().getPlainText().isEmpty())) {
            htmlStart = this.crowdGroupsFetch(this.settings, htmlStart, username);
        }
        htmlStart = htmlStart.append("</table></div>");
        response.setCharacterEncoding("iso-8859-1");
        response.setContentType("text/html");
        response.getOutputStream().write(htmlStart.toString().getBytes(StandardCharsets.UTF_8));
        return null;
    }

    private static boolean isValidURL(String url) {
        if (url == null || url.isEmpty()) {
            return false;
        }
        String regex = "^(https?://)(localhost|([a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,})(:\\d+)?(/.*)?$";
        return url.matches(regex);
    }

    private StringBuffer crowdGroupsFetch(MoSAMLPluginSettings settings, StringBuffer htmlStart, String username) {
        LOGGER.fine("in crowdGroupFetch for test configuration");
        htmlStart.append("<tr><td style=\"font-weight:bold;border:2px solid #949090;padding:2%;\">Groups from Crowd</td>");
        htmlStart.append("<td style=\"padding:2%;border:2px solid #949090;word-wrap:break-word;\">");
        LOGGER.fine("checking Url validation of crowd..");
        if (MoSAMLTemplateManager.isValidURL(settings.getCrowdURL())) {
            LOGGER.fine("crowd url is valid.");
            MoSAMLCrowdGroupManagement crowdGroupManagement = new MoSAMLCrowdGroupManagement();
            ArrayList<String> groupsFromCrowd = crowdGroupManagement.directGroupsFromCrowd(settings, User.get((String)username));
            if (groupsFromCrowd.isEmpty()) {
                LOGGER.fine("User doesn't have any groups in crowd");
                htmlStart.append("No groups are assigned to corresponding user in crowd");
            } else if ("Empty".equals(groupsFromCrowd.get(0))) {
                LOGGER.fine("Groups couldn't be fetched due to status code or invalid application name or password ");
                htmlStart.append("No groups could be fetched from Crowd");
            } else {
                htmlStart.append(StringUtils.join(groupsFromCrowd, (String)"<hr/>"));
            }
        } else {
            LOGGER.fine("crowd url is not valid.");
            htmlStart = htmlStart.append("No groups could be fetched from Crowd");
        }
        htmlStart = htmlStart.append("</td></tr>");
        return htmlStart;
    }
}

