/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.mergify;

import com.coravy.hudson.plugins.github.GithubProjectProperty;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.git.GitSCM;
import hudson.scm.SCM;
import hudson.tasks.BuildStep;
import hudson.tasks.Builder;
import io.jenkins.plugins.mergify.JobMetadata;
import io.jenkins.plugins.mergify.TracerService;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.logging.Logger;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceOwner;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;

public class TraceUtils {
    public static final AttributeKey<String> CICD_PROVIDER_NAME = AttributeKey.stringKey((String)"cicd.provider.name");
    public static final AttributeKey<String> CICD_PIPELINE_NAME = AttributeKey.stringKey((String)"cicd.pipeline.name");
    public static final AttributeKey<String> CICD_PIPELINE_URL = AttributeKey.stringKey((String)"cicd.pipeline.url");
    public static final AttributeKey<Long> CICD_PIPELINE_CREATED_AT = AttributeKey.longKey((String)"cicd.pipeline.created_at");
    public static final AttributeKey<String> CICD_PIPELINE_RESULT = AttributeKey.stringKey((String)"cicd.pipeline.result");
    public static final AttributeKey<List<String>> CICD_PIPELINE_LABELS = AttributeKey.stringArrayKey((String)"cicd.pipeline.labels");
    public static final AttributeKey<String> CICD_PIPELINE_RUN_ID = AttributeKey.stringKey((String)"cicd.pipeline.run.id");
    public static final AttributeKey<Long> CICD_PIPELINE_RUNNER_ID = AttributeKey.longKey((String)"cicd.pipeline.runner.id");
    public static final AttributeKey<String> CICD_PIPELINE_RUNNER_NAME = AttributeKey.stringKey((String)"cicd.pipeline.runner.name");
    public static final AttributeKey<String> CICD_PIPELINE_TASK_RUN_ID = AttributeKey.stringKey((String)"cicd.pipeline.task.run.id");
    public static final AttributeKey<String> CICD_PIPELINE_TASK_NAME = AttributeKey.stringKey((String)"cicd.pipeline.task.name");
    public static final AttributeKey<String> CICD_PIPELINE_TASK_SCOPE = AttributeKey.stringKey((String)"cicd.pipeline.task.scope");
    public static final AttributeKey<String> CICD_PIPELINE_TASK_RUN_RESULT = AttributeKey.stringKey((String)"cicd.pipeline.task.run.result");
    public static final AttributeKey<String> VCS_REF_BASE_NAME = AttributeKey.stringKey((String)"vcs.ref.base.name");
    public static final AttributeKey<String> VCS_REF_HEAD_NAME = AttributeKey.stringKey((String)"vcs.ref.head.name");
    public static final AttributeKey<String> VCS_REF_HEAD_REVISION = AttributeKey.stringKey((String)"vcs.ref.head.revision");
    public static final AttributeKey<String> VCS_REPOSITORY_NAME = AttributeKey.stringKey((String)"vcs.repository.name");
    public static final AttributeKey<String> VCS_REPOSITORY_URL_FULL = AttributeKey.stringKey((String)"vcs.repository.url.full");
    public static final AttributeKey<String> VCS_REPOSITORY_URL_SOURCE = AttributeKey.stringKey((String)"vcs.repository.url.source");
    public static final AttributeKey<String> CICD_PIPELINE_SCOPE = AttributeKey.stringKey((String)"cicd.pipeline.scope");
    public static final AttributeKey<String> CICD_PIPELINE_ID = AttributeKey.stringKey((String)"cicd.pipeline.id");
    private static final Logger LOGGER = Logger.getLogger(TraceUtils.class.getName());

    public static void endJobSpan(Span span, Run<?, ?> run) {
        if (span == null) {
            LOGGER.warning("Got completed job without span");
            return;
        }
        JobMetadata jobSpanMetadata = TraceUtils.getJobMetadata(run);
        jobSpanMetadata.setSCMCheckoutInfoFromBuildData(run);
        jobSpanMetadata.setCommonSpanAttributes(span);
        Result result = run.getResult();
        if (result == null) {
            span.setStatus(StatusCode.UNSET);
            span.setAttribute(CICD_PIPELINE_RESULT, (Object)"unknown");
            span.setAttribute(CICD_PIPELINE_TASK_RUN_RESULT, (Object)"unknown");
        } else if (result.equals(Result.SUCCESS)) {
            span.setStatus(StatusCode.OK);
            span.setAttribute(CICD_PIPELINE_RESULT, (Object)"success");
            span.setAttribute(CICD_PIPELINE_TASK_RUN_RESULT, (Object)"success");
        } else if (result.equals(Result.NOT_BUILT)) {
            span.setStatus(StatusCode.OK);
            span.setAttribute(CICD_PIPELINE_RESULT, (Object)"skipped");
            span.setAttribute(CICD_PIPELINE_TASK_RUN_RESULT, (Object)"skipped");
        } else if (result.equals(Result.ABORTED)) {
            span.setStatus(StatusCode.ERROR);
            span.setAttribute(CICD_PIPELINE_RESULT, (Object)"cancelled");
            span.setAttribute(CICD_PIPELINE_TASK_RUN_RESULT, (Object)"cancelled");
        } else if (result.equals(Result.FAILURE) || result.equals(Result.UNSTABLE)) {
            span.setStatus(StatusCode.ERROR);
            span.setAttribute(CICD_PIPELINE_RESULT, (Object)"failure");
            span.setAttribute(CICD_PIPELINE_TASK_RUN_RESULT, (Object)"failure");
        } else {
            throw new RuntimeException("unexpected result: " + String.valueOf(result));
        }
        span.end();
    }

    public static void endJobStepSpan(Span span, Run<?, ?> run, boolean isError) {
        if (span == null) {
            LOGGER.fine("Got completed stage/step without span");
            return;
        }
        if (run == null) {
            LOGGER.fine("Got completed stage/step without RunSpanAction");
            span.end();
            return;
        }
        JobMetadata jobSpanMetadata = TraceUtils.getJobMetadata(run);
        jobSpanMetadata.setCommonSpanAttributes(span);
        if (isError) {
            span.setAttribute(CICD_PIPELINE_TASK_RUN_RESULT, (Object)"failure");
            span.setStatus(StatusCode.ERROR);
        } else {
            span.setAttribute(CICD_PIPELINE_TASK_RUN_RESULT, (Object)"success");
            span.setStatus(StatusCode.OK);
        }
        span.end();
    }

    private static String getStepName(BuildStep step) {
        if (step instanceof Builder) {
            return ((Builder)step).getDescriptor().getDisplayName();
        }
        return step.getClass().getSimpleName();
    }

    public static Span startJobStepSpan(Run<?, ?> run, Span parentSpan, String stepName, String stepId) {
        if (parentSpan == null) {
            LOGGER.fine("Got completed step without parent span");
            return null;
        }
        Context parentContext = Context.current().with((ImplicitContextKeyed)parentSpan);
        Tracer tracer = TracerService.getTracer();
        return tracer.spanBuilder(stepName).setParent(Context.current().with((ImplicitContextKeyed)parentSpan)).setSpanKind(SpanKind.INTERNAL).setAttribute(CICD_PIPELINE_SCOPE, (Object)"step").setAttribute(CICD_PIPELINE_TASK_SCOPE, (Object)"step").setAttribute(CICD_PIPELINE_TASK_NAME, (Object)stepName).setAttribute(CICD_PIPELINE_TASK_RUN_ID, (Object)stepId).setParent(parentContext).startSpan();
    }

    public static Span startJobSpan(Run<?, ?> run) {
        if (run == null) {
            LOGGER.fine("Got start RootSpan without Run");
            return null;
        }
        Job job = run.getParent();
        Tracer tracer = TracerService.getTracer();
        Span span = tracer.spanBuilder(job.getFullDisplayName()).setSpanKind(SpanKind.SERVER).setAttribute(CICD_PIPELINE_SCOPE, (Object)"job").setAttribute(CICD_PIPELINE_TASK_SCOPE, (Object)"job").setAttribute(CICD_PIPELINE_TASK_NAME, (Object)job.getFullDisplayName()).setAttribute(CICD_PIPELINE_TASK_RUN_ID, (Object)job.getFullDisplayName()).startSpan();
        JobMetadata jobSpanMetadata = TraceUtils.getJobMetadata(run);
        jobSpanMetadata.addRepositoryURL("GitHubProjectProperty", TraceUtils.getGitHubProjectRepositoryUrl(run));
        jobSpanMetadata.addRepositoryURL("SCMRemoteURL", TraceUtils.getSCMRepositoryUrl(run));
        jobSpanMetadata.setSpanContext(span.getSpanContext());
        return span;
    }

    public static JobMetadata getJobMetadata(@Nonnull Run<?, ?> run) {
        JobMetadata jobMetadata = (JobMetadata)run.getAction(JobMetadata.class);
        if (jobMetadata != null) {
            return jobMetadata;
        }
        JobMetadata newJobMetadata = new JobMetadata(run);
        run.addAction((Action)newJobMetadata);
        return newJobMetadata;
    }

    public static String getGitHubProjectRepositoryUrl(Run<?, ?> run) {
        Job job = run.getParent();
        GithubProjectProperty githubProjectProperty = (GithubProjectProperty)job.getProperty(GithubProjectProperty.class);
        if (githubProjectProperty != null) {
            return githubProjectProperty.getProjectUrlStr();
        }
        return null;
    }

    public static String getSCMRepositoryUrl(Run<?, ?> run) {
        SCM scm;
        Job job = run.getParent();
        if (job instanceof SCMSourceOwner) {
            SCMSourceOwner scmOwner = (SCMSourceOwner)job;
            for (SCMSource source : scmOwner.getSCMSources()) {
                if (!(source instanceof GitHubSCMSource)) continue;
                return ((GitHubSCMSource)source).getRemote();
            }
        }
        if (job instanceof AbstractProject && (scm = ((AbstractProject)job).getScm()) instanceof GitSCM) {
            GitSCM gitSCM = (GitSCM)scm;
            return ((URIish)((RemoteConfig)gitSCM.getRepositories().get(0)).getURIs().get(0)).toString();
        }
        return null;
    }
}

