/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.mergify;

import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.Secret;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class OrgApiKey
extends AbstractDescribableImpl<OrgApiKey> {
    private final String organizationName;
    private final Secret apiKey;

    @DataBoundConstructor
    public OrgApiKey(String organizationName, Secret apiKey) {
        this.organizationName = organizationName;
        this.apiKey = apiKey;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public Secret getApiKey() {
        return this.apiKey;
    }

    public String getApiKeyPlainText() {
        return this.apiKey.getPlainText();
    }

    public String toString() {
        return "OrgApiKey{organizationName='" + this.organizationName + "'}";
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<OrgApiKey> {
        public String getDisplayName() {
            return "GitHub Organization's Mergify CI Insights token";
        }

        @POST
        public FormValidation doCheckOrganizationName(@QueryParameter String value) {
            if (value == null || value.isBlank()) {
                return FormValidation.error((String)"Organization name is required.");
            }
            if (!value.matches("[a-zA-Z0-9-]+")) {
                return FormValidation.error((String)"Organization name usually contains only letters, numbers, and dashes.");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckApiKey(@QueryParameter Secret value) {
            if (value == null || value.getPlainText().isBlank()) {
                return FormValidation.error((String)"API key is required.");
            }
            return FormValidation.ok();
        }
    }
}

