/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.mergify;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DashboardUrlBuilder {
    private static final ObjectMapper mapper = new ObjectMapper();

    public static String buildUrl(String login, String repository, String jobName, String pipelineName, String jobTraceId, String jobSpanId) throws Exception {
        ArrayList<Map<String, Object>> filters = new ArrayList<Map<String, Object>>();
        filters.add(DashboardUrlBuilder.makeFilter("job_name", "equals", Collections.singletonList(jobName)));
        filters.add(DashboardUrlBuilder.makeFilter("pipeline_name", "equals", Collections.singletonList(pipelineName)));
        if (repository != null) {
            filters.add(DashboardUrlBuilder.makeFilter("repository", "equals", Collections.singletonList(repository)));
        }
        String json = mapper.writeValueAsString(filters);
        String encoded = URLEncoder.encode(json, StandardCharsets.UTF_8);
        encoded = URLEncoder.encode(encoded, StandardCharsets.UTF_8);
        String url = String.format("/ci-insights/jobs?filters=%s&job_trace_id=%s&job_span_id=%s", encoded, URLEncoder.encode(jobTraceId, StandardCharsets.UTF_8), URLEncoder.encode(jobSpanId, StandardCharsets.UTF_8));
        return String.format("%s&login=%s", url, URLEncoder.encode(login, StandardCharsets.UTF_8));
    }

    private static Map<String, Object> makeFilter(String field, String operator, List<String> value) {
        HashMap<String, Object> filter = new HashMap<String, Object>();
        filter.put("field", field);
        filter.put("operator", operator);
        filter.put("value", value);
        return filter;
    }
}

