/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.mergify;

import hudson.BulkChange;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Saveable;
import hudson.util.FormValidation;
import io.jenkins.plugins.mergify.MergifyConfigurationProvider;
import io.jenkins.plugins.mergify.OrgApiKey;
import io.jenkins.plugins.mergify.TracerService;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.verb.POST;

@Extension
public class MergifyConfiguration
extends GlobalConfiguration
implements MergifyConfigurationProvider {
    private List<OrgApiKey> orgApiKeys;
    private String url;

    public MergifyConfiguration() {
        this.load();
        if (this.orgApiKeys == null) {
            this.orgApiKeys = new ArrayList<OrgApiKey>();
        }
        if (this.url == null) {
            this.url = "https://api.mergify.com";
        }
    }

    public static MergifyConfiguration get() {
        return (MergifyConfiguration)GlobalConfiguration.all().get(MergifyConfiguration.class);
    }

    @Override
    public String getApiKeyForOrg(String organizationName) {
        List<OrgApiKey> orgApiKeys = this.getOrgApiKeys();
        if (orgApiKeys != null) {
            for (OrgApiKey entry : orgApiKeys) {
                if (!entry.getOrganizationName().equals(organizationName)) continue;
                return entry.getApiKey().getPlainText();
            }
        }
        return null;
    }

    @Exported
    public List<OrgApiKey> getOrgApiKeys() {
        return this.orgApiKeys;
    }

    public void setOrgApiKeys(List<OrgApiKey> orgApiKeys) {
        this.orgApiKeys = orgApiKeys;
        this.save();
    }

    @Override
    @Exported
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = Util.fixEmptyAndTrim((String)url);
        this.save();
    }

    public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
        this.orgApiKeys = null;
        req.bindJSON((Object)this, json);
        return true;
    }

    public void save() {
        if (BulkChange.contains((Saveable)this)) {
            return;
        }
        super.save();
        TracerService.clearMergifySpanExporters();
    }

    @POST
    public FormValidation doCheckUrl(@QueryParameter(value="url") String value) throws IOException, ServletException {
        String valueTrim = Util.fixEmptyAndTrim((String)value);
        if (valueTrim == null) {
            return FormValidation.error((String)"Mergify API URL cannot be empty.");
        }
        try {
            new URL(valueTrim);
        }
        catch (MalformedURLException e) {
            return FormValidation.error((String)"Invalid URL format.");
        }
        if (!valueTrim.startsWith("https://")) {
            return FormValidation.error((String)"URL must start with 'https://'.");
        }
        if (valueTrim.endsWith("/")) {
            return FormValidation.error((String)"URL must not contain ending /.");
        }
        return FormValidation.ok();
    }

    protected HttpURLConnection openConnection(URL url) throws IOException {
        return (HttpURLConnection)url.openConnection();
    }

    @POST
    public FormValidation doTestConnection(@QueryParameter(value="url") String value) throws IOException, ServletException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        try {
            URL url = new URL(value);
            HttpURLConnection connection = this.openConnection(url);
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(3000);
            connection.setReadTimeout(3000);
            connection.setInstanceFollowRedirects(true);
            connection.connect();
            int statusCode = connection.getResponseCode();
            connection.disconnect();
            if (statusCode >= 200 && statusCode < 400) {
                return FormValidation.ok((String)"Success");
            }
            return FormValidation.error((String)("HTTP " + statusCode + " error: " + connection.getResponseMessage()));
        }
        catch (Exception e) {
            return FormValidation.error((String)("Client error : " + e.getMessage()));
        }
    }
}

