/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.mergify;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.plugins.git.GitSCM;
import hudson.scm.SCM;
import hudson.scm.SCMRevisionState;
import hudson.tasks.BuildStep;
import hudson.tasks.Builder;
import hudson.tasks.Publisher;
import io.jenkins.plugins.mergify.JobMetadata;
import io.jenkins.plugins.mergify.TraceUtils;
import io.jenkins.plugins.mergify.TraceparentAction;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.workflow.actions.ErrorAction;
import org.jenkinsci.plugins.workflow.actions.LabelAction;
import org.jenkinsci.plugins.workflow.cps.nodes.StepEndNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepStartNode;
import org.jenkinsci.plugins.workflow.flow.GraphListener;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.support.steps.StageStep;

@Extension
public class Listener
extends RunListener<Run<?, ?>>
implements GraphListener.Synchronous {
    private static final Logger LOGGER = Logger.getLogger(Listener.class.getName());
    private static final Map<FlowNode, Span> stageSpans = new ConcurrentHashMap<FlowNode, Span>();
    private static final Map<BuildStep, Span> stepSpans = new ConcurrentHashMap<BuildStep, Span>();
    private static final Map<Run<?, ?>, Span> buildSpans = new ConcurrentHashMap();

    @CheckForNull
    private static WorkflowRun getWorkflowRun(@NonNull FlowNode flowNode) {
        Queue.Executable executable;
        try {
            executable = flowNode.getExecution().getOwner().getExecutable();
        }
        catch (IOException e) {
            return null;
        }
        if (executable instanceof WorkflowRun) {
            return (WorkflowRun)executable;
        }
        return null;
    }

    private static boolean isStageStartNode(FlowNode node) {
        if (!(node instanceof StepStartNode)) {
            return false;
        }
        StepStartNode stepStartNode = (StepStartNode)node;
        StepDescriptor nodeDescriptor = stepStartNode.getDescriptor();
        return nodeDescriptor instanceof StageStep.DescriptorImpl && node.getAction(LabelAction.class) != null;
    }

    private static boolean isStageEndNode(FlowNode node) {
        if (!(node instanceof StepEndNode)) {
            return false;
        }
        StepStartNode stepStartNode = (StepStartNode)((StepEndNode)node).getStartNode();
        return Listener.isStageStartNode((FlowNode)stepStartNode);
    }

    static boolean isValidBuildStep(BuildStep step) {
        return step instanceof Builder || step instanceof Publisher || Jenkins.get().getExtensionList(BuildStep.class).contains((Object)step);
    }

    private static String getStageName(StepStartNode stepStartNode) {
        return "Stage(" + stepStartNode.getDisplayFunctionName() + ")";
    }

    public void onNewHead(FlowNode node) {
        if (Listener.isStageStartNode(node)) {
            this.startStageSpan(node);
        } else if (Listener.isStageEndNode(node)) {
            this.endStageSpan((StepEndNode)node);
        } else if (node.getAction(TraceparentAction.class) == null) {
            for (FlowNode parent : node.getParents()) {
                TraceparentAction parentSpan = (TraceparentAction)parent.getAction(TraceparentAction.class);
                if (parentSpan == null) continue;
                node.addAction((Action)parentSpan);
                break;
            }
        }
    }

    public void onStarted(Run<?, ?> run, @NonNull TaskListener listener) {
        LOGGER.fine("build " + run.getFullDisplayName() + " started");
        Span span = TraceUtils.startJobSpan(run);
        if (span != null) {
            buildSpans.put(run, span);
        }
    }

    public void onFinalized(Run<?, ?> run) {
        LOGGER.fine("build " + run.getFullDisplayName() + " completed");
        Span span = buildSpans.remove(run);
        TraceUtils.endJobSpan(span, run);
    }

    private void startStageSpan(FlowNode node) {
        WorkflowRun run = Listener.getWorkflowRun(node);
        StepStartNode stepStartNode = (StepStartNode)node;
        String stageName = Listener.getStageName(stepStartNode);
        Span parentSpan = buildSpans.get(run);
        Span span = TraceUtils.startJobStepSpan(run, parentSpan, stageName, stepStartNode.getId());
        if (span != null) {
            SpanContext spanContext = span.getSpanContext();
            stepStartNode.addAction((Action)new TraceparentAction(spanContext));
            stageSpans.put(node, span);
        }
        LOGGER.fine("Stage started: " + stageName);
    }

    private void endStageSpan(StepEndNode stepEndNode) {
        StepStartNode stepStartNode = (StepStartNode)stepEndNode.getStartNode();
        Span span = stageSpans.get(stepStartNode);
        WorkflowRun run = Listener.getWorkflowRun((FlowNode)stepStartNode);
        ErrorAction error = stepEndNode.getError();
        TraceUtils.endJobStepSpan(span, run, error != null);
        String stageName = Listener.getStageName(stepStartNode);
        LOGGER.fine("Stage stopped: " + stageName);
    }

    @Extension
    public static class SCMListener
    extends hudson.model.listeners.SCMListener {
        private static EnvVars getEnvironment(Run<?, ?> run, TaskListener listener) {
            try {
                return run.getEnvironment(listener);
            }
            catch (IOException | InterruptedException e) {
                return null;
            }
        }

        public void onCheckout(Run<?, ?> run, SCM scm, FilePath workspace, TaskListener listener, File changelogFile, SCMRevisionState pollingBaseline) throws IOException, InterruptedException {
            LOGGER.fine("SCM checkout hooks!");
            JobMetadata jobSpanMetadata = TraceUtils.getJobMetadata(run);
            EnvVars envVars = SCMListener.getEnvironment(run, listener);
            if (envVars != null) {
                LOGGER.fine("Got SCM checkout data: " + String.valueOf(envVars));
                jobSpanMetadata.setSCMCheckoutInfoFromEnvs(envVars);
            }
            if (scm instanceof GitSCM) {
                GitSCM gitSCM = (GitSCM)scm;
                GitClient client = gitSCM.createClient(listener, envVars, run, workspace);
                jobSpanMetadata.setSCMCheckoutInfoFromGitSCM(gitSCM, client);
            } else {
                LOGGER.fine("SCM is not GitSCM, skipping checkout info");
            }
        }
    }

    @Extension
    public static class BuildStepListener
    extends hudson.model.BuildStepListener {
        private static String getStepName(BuildStep step) {
            if (step instanceof Builder) {
                return ((Builder)step).getDescriptor().getDisplayName();
            }
            return step.getClass().getSimpleName();
        }

        public void started(AbstractBuild build, BuildStep step, BuildListener listener) {
            if (!Listener.isValidBuildStep(step)) {
                LOGGER.fine("Step ignored: " + String.valueOf(step));
                return;
            }
            String stepName = BuildStepListener.getStepName(step);
            Span parentSpan = buildSpans.get(build);
            Span span = TraceUtils.startJobStepSpan(build, parentSpan, stepName, step.toString());
            if (span != null) {
                stepSpans.put(step, span);
                SpanContext spanContext = span.getSpanContext();
                build.addOrReplaceAction((Action)new TraceparentAction(spanContext));
            }
            LOGGER.fine("Step started: " + stepName);
        }

        public void finished(AbstractBuild build, BuildStep step, BuildListener listener, boolean canContinue) {
            if (!Listener.isValidBuildStep(step)) {
                LOGGER.fine("Step ignored: " + String.valueOf(step));
                return;
            }
            Span span = stepSpans.get(step);
            TraceUtils.endJobStepSpan(span, build, !canContinue);
            String stepName = BuildStepListener.getStepName(step);
            LOGGER.fine("Step stopped: " + stepName);
        }
    }
}

