/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.mergify;

import hudson.EnvVars;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.InvisibleAction;
import hudson.model.Job;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Run;
import hudson.plugins.git.Branch;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.Revision;
import hudson.plugins.git.UserRemoteConfig;
import hudson.plugins.git.util.BuildData;
import io.jenkins.plugins.mergify.TraceUtils;
import io.opentelemetry.api.trace.Span;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.gitclient.GitClient;

public class JobMetadata
extends InvisibleAction {
    private static final Logger LOGGER = Logger.getLogger(JobMetadata.class.getName());
    private final String pipelineName;
    private final String pipelineId;
    private final String pipelineUrl;
    private final String pipelineRunnerName;
    private final List<String> pipelineLabels;
    private final Integer pipelineRunnerId;
    private final Long pipelineCreatedAt;
    private volatile String SCMCheckoutBranch;
    private volatile String SCMCheckoutCommit;
    private Map<String, String> repositoryURLs;

    public JobMetadata(Run<?, ?> run) {
        Job job = run.getParent();
        this.pipelineName = job.getFullDisplayName();
        this.pipelineId = run.getExternalizableId();
        this.pipelineUrl = run.getUrl();
        this.repositoryURLs = new LinkedHashMap<String, String>();
        this.pipelineCreatedAt = run.getTimeInMillis();
        Executor executor = run.getExecutor();
        if (executor == null) {
            LOGGER.warning("Run executor is null, cannot set pipeline runner info");
            this.pipelineRunnerId = null;
            this.pipelineRunnerName = null;
            this.pipelineLabels = List.of();
            return;
        }
        Computer computer = executor.getOwner();
        String nodeName = computer.getName();
        this.pipelineRunnerId = executor.getNumber();
        this.pipelineRunnerName = nodeName.isEmpty() ? "built-in" : nodeName;
        Node node = executor.getOwner().getNode();
        if (node == null) {
            this.pipelineLabels = List.of();
        } else {
            Set labels = node.getAssignedLabels();
            this.pipelineLabels = labels.stream().map(Label::getName).collect(Collectors.toList());
        }
    }

    static String getRepositoryName(String url) {
        if (url == null || url.isEmpty()) {
            return null;
        }
        url = url.replaceAll("/$", "").replaceAll("\\.git$", "");
        Pattern pattern = Pattern.compile("[:/]([^:/]+)/([^:/]+?)(?:\\.git)?$");
        Matcher matcher = pattern.matcher(url);
        if (matcher.find()) {
            return matcher.group(1) + "/" + matcher.group(2);
        }
        return null;
    }

    private Object readResolve() {
        if (this.repositoryURLs == null) {
            this.repositoryURLs = new ConcurrentHashMap<String, String>();
        }
        return this;
    }

    public void setCommonSpanAttributes(Span span) {
        block8: {
            Iterator<Map.Entry<String, String>> iterator;
            if (this.repositoryURLs.isEmpty()) {
                LOGGER.warning("repositoryURLs is empty, skipping span");
                return;
            }
            if (this.SCMCheckoutBranch == null) {
                LOGGER.warning("SCMCheckoutBranch is null, skipping span");
                return;
            }
            if (this.SCMCheckoutCommit == null) {
                LOGGER.warning("SCMCheckoutCommit is null, skipping span");
                return;
            }
            span.setAttribute(TraceUtils.CICD_PROVIDER_NAME, (Object)"jenkins");
            span.setAttribute(TraceUtils.CICD_PIPELINE_NAME, (Object)this.pipelineName);
            span.setAttribute(TraceUtils.CICD_PIPELINE_RUN_ID, (Object)this.pipelineId);
            span.setAttribute(TraceUtils.CICD_PIPELINE_ID, (Object)this.pipelineId);
            span.setAttribute(TraceUtils.CICD_PIPELINE_CREATED_AT, (Object)this.pipelineCreatedAt);
            span.setAttribute(TraceUtils.CICD_PIPELINE_URL, (Object)(Jenkins.get().getRootUrl() + this.pipelineUrl));
            span.setAttribute(TraceUtils.CICD_PIPELINE_LABELS, this.pipelineLabels);
            if (this.SCMCheckoutBranch != null) {
                span.setAttribute(TraceUtils.VCS_REF_HEAD_NAME, (Object)this.SCMCheckoutBranch.replaceFirst("^[^/]+/", ""));
            } else {
                span.setAttribute(TraceUtils.VCS_REF_HEAD_NAME, (Object)"<unknown>");
            }
            span.setAttribute(TraceUtils.VCS_REF_HEAD_REVISION, (Object)this.SCMCheckoutCommit);
            if (this.pipelineRunnerId != null) {
                span.setAttribute(TraceUtils.CICD_PIPELINE_RUNNER_ID, this.pipelineRunnerId.intValue());
            }
            if (this.pipelineRunnerName != null) {
                span.setAttribute(TraceUtils.CICD_PIPELINE_RUNNER_NAME, (Object)this.pipelineRunnerName);
            }
            if (!(iterator = this.repositoryURLs.entrySet().iterator()).hasNext()) break block8;
            Map.Entry<String, String> entry = iterator.next();
            String name = entry.getKey();
            String url = entry.getValue();
            LOGGER.fine("Using Repository URL from " + name);
            span.setAttribute(TraceUtils.VCS_REPOSITORY_URL_FULL, (Object)url);
            span.setAttribute(TraceUtils.VCS_REPOSITORY_URL_SOURCE, (Object)name);
            String repositoryName = JobMetadata.getRepositoryName(url);
            if (repositoryName != null) {
                span.setAttribute(TraceUtils.VCS_REPOSITORY_NAME, (Object)repositoryName);
            }
        }
    }

    public void addRepositoryURL(String name, String url) {
        if (url == null || url.isEmpty()) {
            return;
        }
        this.repositoryURLs.put(name, url);
    }

    public void setSCMCheckoutInfoFromEnvs(EnvVars envVars) {
        this.addRepositoryURL("SCMCheckoutURL", (String)envVars.get((Object)"GIT_URL"));
        if (this.SCMCheckoutBranch != null && this.SCMCheckoutCommit != null) {
            return;
        }
        this.SCMCheckoutCommit = (String)envVars.get((Object)"GIT_COMMIT");
        this.SCMCheckoutBranch = (String)envVars.get((Object)"GIT_BRANCH");
    }

    public void setSCMCheckoutInfoFromBuildData(Run<?, ?> run) {
        block4: {
            Revision revision;
            if (this.SCMCheckoutBranch != null && this.SCMCheckoutCommit != null) {
                return;
            }
            BuildData data = (BuildData)run.getAction(BuildData.class);
            if (data == null) {
                return;
            }
            Set urls = data.getRemoteUrls();
            Iterator iterator = urls.iterator();
            if (iterator.hasNext()) {
                String url = (String)iterator.next();
                this.addRepositoryURL("SCMCheckoutURL", url);
            }
            if ((revision = data.getLastBuiltRevision()) == null) break block4;
            this.SCMCheckoutCommit = revision.getSha1String();
            Collection branches = revision.getBranches();
            Iterator iterator2 = branches.iterator();
            if (iterator2.hasNext()) {
                Branch branch = (Branch)iterator2.next();
                this.SCMCheckoutBranch = branch.getName();
            }
        }
    }

    public void setSCMCheckoutInfoFromGitSCM(GitSCM gitSCM, GitClient client) throws InterruptedException {
        if (this.SCMCheckoutBranch != null && this.SCMCheckoutCommit != null) {
            return;
        }
        List remoteConfigs = gitSCM.getUserRemoteConfigs();
        this.addRepositoryURL("GitSCM", remoteConfigs.isEmpty() ? null : ((UserRemoteConfig)remoteConfigs.get(0)).getUrl());
        List branches = gitSCM.getBranches();
        this.SCMCheckoutBranch = branches.isEmpty() ? null : ((BranchSpec)branches.get(0)).getName();
        this.SCMCheckoutCommit = client.revParse("HEAD").name();
    }
}

